/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;

public class RiteEffectBindSpiritsToFetish
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectBindSpiritsToFetish> DESERIALIZER = json -> new RiteEffectBindSpiritsToFetish(ItemRiteSacrifice.parseIdentifier(json.get("fetish").getAsString()), JsonUtils.getInt((JsonObject)json, (String)"radius", (int)5));
    private final long fetish;
    private final int radius;

    public RiteEffectBindSpiritsToFetish(long fetish, int radius) {
        this.fetish = fetish;
        this.radius = radius;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        ArrayListMultimap ghosts = ArrayListMultimap.create();
        for (EntityCreature entity : world.getEntitiesWithinAABB(EntityCreature.class, new AxisAlignedBB(pos.add(-this.radius, -this.radius, -this.radius), pos.add(this.radius, this.radius, this.radius)))) {
            ghosts.put(entity.getClass(), (Object)entity);
        }
        RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.fetish);
        if (sacrificedItem == null) {
            return RiteHandler.Result.ABORTED_REFUND;
        }
        return InfusedSpiritEffect.tryBindFetish(world, pos, sacrificedItem.getStack(), (ListMultimap<Class<? extends EntityCreature>, EntityCreature>)ghosts) ? RiteHandler.Result.COMPLETED : RiteHandler.Result.ABORTED_REFUND;
    }
}

