/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.curse;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.rite.curse.Curse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/msrandom/witchery/rite/curse/MisfortuneCurse;", "Lnet/msrandom/witchery/rite/curse/Curse;", "()V", "affectEntity", "", "level", "", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "WitcheryResurrected"})
public final class MisfortuneCurse
implements Curse {
    @Override
    public void affectEntity(int level, @NotNull EntityLivingBase entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!(entity.isPotionActive(MobEffects.BLINDNESS) || entity.isPotionActive(MobEffects.WEAKNESS) || entity.isPotionActive(MobEffects.MINING_FATIGUE) || entity.isPotionActive(MobEffects.SLOWNESS) || entity.isPotionActive(MobEffects.POISON) || entity.world.rand.nextInt(20) != 0)) {
            switch (entity.world.rand.nextInt(RangesKt.coerceAtMost((int)level, (int)5) + 1)) {
                case 0: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 600, RangesKt.coerceAtMost((int)(level - 1), (int)4)));
                    break;
                }
                case 1: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 600, RangesKt.coerceAtMost((int)(level - 1), (int)4)));
                    break;
                }
                case 2: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, (13 + 2 * level) * 20, RangesKt.coerceAtMost((int)(level - 2), (int)4)));
                    break;
                }
                case 3: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.BLINDNESS, 5 * level * 20));
                    if (level <= 5) break;
                    entity.addPotionEffect(new PotionEffect(MobEffects.NIGHT_VISION, 5 * level * 20));
                    break;
                }
                case 5: {
                    if (entity instanceof EntityPlayer) {
                        int heldItemIndex = ((EntityPlayer)entity).inventory.currentItem;
                        Object object = ((EntityPlayer)entity).inventory.mainInventory.get(heldItemIndex);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"entity.inventory.mainInventory[heldItemIndex]");
                        if (!((ItemStack)object).isEmpty()) {
                            ((EntityPlayer)entity).dropItem((ItemStack)((EntityPlayer)entity).inventory.mainInventory.get(heldItemIndex), false);
                            ((EntityPlayer)entity).inventory.mainInventory.set(heldItemIndex, (Object)ItemStack.EMPTY);
                        }
                        return;
                    }
                    ItemStack heldItem = entity.getHeldItemMainhand();
                    ItemStack offItem = entity.getHeldItemMainhand();
                    ItemStack itemStack = heldItem;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"heldItem");
                    if (!itemStack.isEmpty()) {
                        Infusion.dropEntityItemWithRandomChoice(entity, heldItem, true);
                        entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    }
                    ItemStack itemStack2 = offItem;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"offItem");
                    if (itemStack2.isEmpty()) break;
                    Infusion.dropEntityItemWithRandomChoice(entity, offItem, true);
                    entity.setItemStackToSlot(EntityEquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    break;
                }
            }
        }
    }
}

