/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.infusion.symbol.StrokeArray;
import net.msrandom.witchery.infusion.symbol.StrokeSet;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateSymbolEffects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\fJ\u001a\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u0012J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lnet/msrandom/witchery/resources/SymbolEffectManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "defaults", "Ljava/util/HashMap;", "Lnet/msrandom/witchery/infusion/symbol/SymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/StrokeSet;", "Lkotlin/collections/HashMap;", "effects", "Lnet/msrandom/witchery/infusion/symbol/StrokeArray;", "getEffects", "()Ljava/util/HashMap;", "apply", "", "value", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "getDefaultStrokes", "effect", "getEffect", "strokes", "updateEffects", "validStrokes", "", "WitcheryResurrected"})
public final class SymbolEffectManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    @NotNull
    private static final HashMap<StrokeArray, StrokeSet> effects;
    private static final HashMap<SymbolEffect, StrokeSet> defaults;
    public static final SymbolEffectManager INSTANCE;

    @NotNull
    public final HashMap<StrokeArray, StrokeSet> getEffects() {
        return effects;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)resourceManager, (String)"resourceManager");
        effects.clear();
        defaults.clear();
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator = resourceLocation.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement element = entry3.getValue();
            try {
                BranchStroke[] strokes;
                void $this$mapTo$iv$iv;
                JsonObject json = JsonUtils.getJsonObject((JsonElement)element, (String)"top element");
                if (json.size() == 0) continue;
                JsonElement jsonElement = json.get("level");
                int level = jsonElement != null ? jsonElement.getAsInt() : 1;
                JsonArray jsonArray = JsonUtils.getJsonArray((JsonObject)json, (String)"strokes");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"JsonUtils.getJsonArray(json, \"strokes\")");
                Iterable $this$map$iv = (Iterable)jsonArray;
                boolean $i$f$map = false;
                Object object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    void it;
                    JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2.getAsString(), (String)"it.asString");
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                    BranchStroke branchStroke = BranchStroke.valueOf(string3);
                    collection.add(branchStroke);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new BranchStroke[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object v = SymbolEffect.REGISTRY.get(new ResourceLocation(JsonUtils.getString((JsonObject)json, (String)"result")));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                SymbolEffect result2 = (SymbolEffect)v;
                JsonElement jsonElement3 = json.get("default");
                StrokeSet set2 = new StrokeSet(result2, level, strokes, jsonElement3 != null && jsonElement3.getAsBoolean());
                if (set2.isDefault()) {
                    object = defaults;
                    boolean bl5 = false;
                    Object object2 = object;
                    boolean bl6 = false;
                    if (!object2.containsKey(result2)) {
                        ((Map)defaults).put(result2, set2);
                    }
                }
                ((Map)effects).put(set2.getStrokes(), set2);
            }
            catch (RuntimeException exception) {
                void key;
                LOGGER.error("Parsing error loading symbol effect " + key, (Throwable)exception);
            }
        }
        LOGGER.info("Loaded " + effects.size() + " symbol effects");
        WitcheryNetworkChannel.sendToAll(new PacketUpdateSymbolEffects((Map<StrokeArray, StrokeSet>)effects));
    }

    @Nullable
    public final StrokeSet getDefaultStrokes(@NotNull SymbolEffect effect) {
        Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
        return defaults.get(effect);
    }

    @Nullable
    public final StrokeSet getEffect(@NotNull StrokeArray strokes) {
        Intrinsics.checkParameterIsNotNull((Object)strokes, (String)"strokes");
        return effects.get(strokes);
    }

    public final boolean validStrokes(@NotNull StrokeArray strokes) {
        Intrinsics.checkParameterIsNotNull((Object)strokes, (String)"strokes");
        return this.getEffect(strokes) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateEffects(@NotNull Map<StrokeArray, StrokeSet> effects2) {
        Intrinsics.checkParameterIsNotNull(effects2, (String)"effects");
        Object object = effects2;
        boolean bl = false;
        for (Map.Entry<StrokeArray, StrokeSet> entry2 : object.entrySet()) {
            void strokes;
            Object object2 = entry2;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry2;
            bl2 = false;
            StrokeSet set2 = object2.getValue();
            ((Map)effects).put(strokes, set2);
            if (!set2.isDefault()) continue;
            object2 = defaults;
            SymbolEffect symbolEffect = set2.getResult();
            boolean bl3 = false;
            Object object3 = object2;
            boolean bl4 = false;
            if (object3.containsKey(symbolEffect)) continue;
            ((Map)defaults).put(set2.getResult(), set2);
        }
    }

    private SymbolEffectManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "symbol_effects");
    }

    static {
        SymbolEffectManager symbolEffectManager;
        INSTANCE = symbolEffectManager = new SymbolEffectManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(SymbolEffectManager.class).getSimpleName()));
        boolean bl = false;
        effects = new HashMap();
        bl = false;
        defaults = new HashMap();
    }
}

