/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.infusion.creature.CreaturePower;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateCreaturePowers;
import net.msrandom.witchery.registry.RegistryWrappers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J)\u0010\u0016\u001a\u00020\u000f2\u001a\u0010\u0017\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\n2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R=\u0010\u0006\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lnet/msrandom/witchery/resources/CreaturePowerManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "creaturePowers", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lnet/minecraft/entity/Entity;", "Lnet/msrandom/witchery/infusion/creature/CreaturePower;", "Lkotlin/collections/HashMap;", "getCreaturePowers", "()Ljava/util/HashMap;", "apply", "", "value", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializePowers", "map", "", "deserializePowers$WitcheryResurrected", "getPower", "entityType", "entity", "parseAbility", "Lnet/msrandom/witchery/infusion/creature/CreatureAbility;", "element", "WitcheryResurrected"})
public final class CreaturePowerManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    @NotNull
    private static final HashMap<Class<? extends Entity>, CreaturePower> creaturePowers;
    public static final CreaturePowerManager INSTANCE;

    @NotNull
    public final HashMap<Class<? extends Entity>, CreaturePower> getCreaturePowers() {
        return creaturePowers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)resourceManager, (String)"resourceManager");
        creaturePowers.clear();
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator = resourceLocation.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement element = entry3.getValue();
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                JsonObject json = element.getAsJsonObject();
                if (json.size() == 0) continue;
                EntityType<?> entityType = RegistryWrappers.ENTITIES.get((ResourceLocation)key);
                if (entityType == null || (entityType = entityType.getEntityClass()) == null) {
                    throw (Throwable)new JsonSyntaxException("Unknown or invalid entity type " + key);
                }
                EntityType<?> entityClass = entityType;
                JsonArray jsonArray = json.getAsJsonArray("abilities");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"json.getAsJsonArray(\"abilities\")");
                Iterable iterable = (Iterable)jsonArray;
                CreaturePowerManager creaturePowerManager = this;
                boolean $i$f$map = false;
                void var13_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    CreatureAbility creatureAbility = creaturePowerManager.parseAbility((JsonElement)p1);
                    collection.add(creatureAbility);
                }
                List abilities = (List)destination$iv$iv;
                JsonElement jsonElement = json.get("sacrifice_charges");
                ((Map)creaturePowers).put(entityClass, new CreaturePower(jsonElement != null ? jsonElement.getAsInt() : 10, abilities));
            }
            catch (RuntimeException exception) {
                LOGGER.error("Parsing error creature power for entity " + key, (Throwable)exception);
            }
        }
        LOGGER.info("Loaded " + creaturePowers.size() + " creature powers");
        WitcheryNetworkChannel.sendToAll(new PacketUpdateCreaturePowers((Map<Class<? extends Entity>, CreaturePower>)creaturePowers));
    }

    private final CreatureAbility parseAbility(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        String s = JsonUtils.getString((JsonObject)json, (String)"type");
        CreatureAbility.AbilitySerializer abilitySerializer = (CreatureAbility.AbilitySerializer)CreatureAbility.AbilitySerializer.REGISTRY.get(new ResourceLocation(s));
        if (abilitySerializer == null) {
            throw (Throwable)new JsonSyntaxException("Invalid or unsupported creature power ability type '" + s + '\'');
        }
        CreatureAbility.AbilitySerializer serializer = abilitySerializer;
        Object t = serializer.read(json);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"serializer.read(json)");
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public final void deserializePowers$WitcheryResurrected(@NotNull Map<Class<? extends Entity>, CreaturePower> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        creaturePowers.clear();
        Object object = map;
        boolean bl = false;
        Iterator<Map.Entry<Class<? extends Entity>, CreaturePower>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void type;
            Map.Entry<Class<? extends Entity>, CreaturePower> entry2;
            Map.Entry<Class<? extends Entity>, CreaturePower> entry3 = entry2 = iterator.next();
            boolean bl2 = false;
            object = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            CreaturePower power = entry3.getValue();
            ((Map)creaturePowers).put(type, power);
        }
    }

    @Nullable
    public final CreaturePower getPower(@NotNull Class<? extends Entity> entityType) {
        Intrinsics.checkParameterIsNotNull(entityType, (String)"entityType");
        return creaturePowers.get(entityType);
    }

    @Nullable
    public final CreaturePower getPower(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return this.getPower(entity.getClass());
    }

    private CreaturePowerManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "creature_powers");
    }

    static {
        CreaturePowerManager creaturePowerManager;
        INSTANCE = creaturePowerManager = new CreaturePowerManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(CreaturePowerManager.class).getSimpleName()));
        boolean bl = false;
        creaturePowers = new HashMap();
    }
}

