/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.resources.ReloadListener;
import net.minecraft.resources.Resource;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateAlternateFormStats;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.AlternateFormStatType;
import net.msrandom.witchery.transformation.TransformationType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001a\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\f\u001a\u00020\u0004*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lnet/msrandom/witchery/resources/AlternateFormStatManager;", "Lnet/minecraft/resources/ReloadListener;", "", "Lnet/msrandom/witchery/transformation/AlternateForm;", "Lnet/msrandom/witchery/transformation/AlternateForm$Stats;", "()V", "GSON", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "<set-?>", "stats", "getStats", "()Ljava/util/Map;", "(Lnet/msrandom/witchery/transformation/AlternateForm;)Lnet/msrandom/witchery/transformation/AlternateForm$Stats;", "apply", "", "value", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializeStats", "map", "prepare", "WitcheryResurrected"})
public final class AlternateFormStatManager
extends ReloadListener<Map<AlternateForm, AlternateForm.Stats>> {
    private static final Gson GSON;
    private static final Logger LOGGER;
    @NotNull
    private static Map<AlternateForm, AlternateForm.Stats> stats;
    public static final AlternateFormStatManager INSTANCE;

    @NotNull
    public final Map<AlternateForm, AlternateForm.Stats> getStats() {
        return stats;
    }

    @NotNull
    public final AlternateForm.Stats getStats(@NotNull AlternateForm $this$stats) {
        Intrinsics.checkParameterIsNotNull((Object)$this$stats, (String)"$this$stats");
        AlternateForm.Stats stats2 = stats.computeIfAbsent($this$stats, stats.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)stats2, (String)"AlternateFormStatManager\u2026fAbsent(this) { Stats() }");
        return stats2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<AlternateForm, AlternateForm.Stats> prepare(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull((Object)resourceManager, (String)"resourceManager");
        boolean bl = false;
        HashMap statMap = new HashMap();
        Iterator iterator = AlternateForm.REGISTRY.iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator.next();
            boolean bl2 = false;
            ResourceLocation resourceLocation = (ResourceLocation)entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            AlternateForm form = (AlternateForm)entry3.getValue();
            ResourceLocation location = new ResourceLocation(key.getNamespace(), "alternate_forms/" + key.getPath() + ".json");
            try {
                Closeable closeable = resourceManager.getResource(location);
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Resource resource = (Resource)closeable;
                    boolean bl4 = false;
                    Closeable closeable2 = new InputStreamReader(resource.getInputStream());
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        JsonElement it;
                        JsonElement jsonElement;
                        boolean bl6;
                        boolean bl7;
                        InputStreamReader reader = (InputStreamReader)closeable2;
                        boolean bl8 = false;
                        JsonObject data = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        AlternateForm.Stats formStats = new AlternateForm.Stats();
                        if (data.get("transformation") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl9 = false;
                            formStats.setTransformationType((TransformationType)TransformationType.REGISTRY.get(new ResourceLocation(it.getAsString())));
                        }
                        if (data.get("width") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl10 = false;
                            formStats.setWidth(it.getAsFloat());
                        }
                        if (data.get("height") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl11 = false;
                            formStats.setHeight(it.getAsFloat());
                        }
                        if (data.get("step_height") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl12 = false;
                            formStats.setStepHeight(it.getAsFloat());
                        }
                        if (data.get("eye_height") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl13 = false;
                            formStats.setEyeHeight(it.getAsFloat());
                        }
                        if (data.get("reflection_damage") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl14 = false;
                            formStats.setReflectionDamage(it.getAsDouble());
                        }
                        if (data.get("flying") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl15 = false;
                            formStats.setCanFly(it.getAsBoolean());
                        }
                        if (data.get("howling") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl16 = false;
                            formStats.setCanHowl(it.getAsBoolean());
                        }
                        if (data.get("holdable_item") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl17 = false;
                            Item item = RegistryWrappers.ITEMS.get(new ResourceLocation(it.getAsString()));
                            if (item == null) {
                                Item item2 = Items.AIR;
                                item = item2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"Items.AIR");
                            }
                            formStats.setHoldableItem(item);
                        }
                        if (data.get("wears_armor") != null) {
                            bl7 = false;
                            bl6 = false;
                            it = jsonElement;
                            boolean bl18 = false;
                            formStats.setWearsArmor(it.getAsBoolean());
                        }
                        JsonArray jsonArray = data.getAsJsonArray("stats");
                        if (jsonArray != null) {
                            Iterable $this$forEach$iv = (Iterable)jsonArray;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                JsonElement it2 = (JsonElement)element$iv;
                                boolean bl19 = false;
                                JsonElement jsonElement2 = it2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"it");
                                JsonObject obj = jsonElement2.getAsJsonObject();
                                Object2FloatOpenHashMap map = new Object2FloatOpenHashMap();
                                Iterator iterator2 = obj.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    void k;
                                    Map.Entry entry4;
                                    Map.Entry entry5 = entry4 = (Map.Entry)iterator2.next();
                                    boolean bl20 = false;
                                    String string = (String)entry5.getKey();
                                    entry5 = entry4;
                                    bl20 = false;
                                    JsonElement v = (JsonElement)entry5.getValue();
                                    if (!(Intrinsics.areEqual((Object)k, (Object)"level") ^ true)) continue;
                                    Map map2 = (Map)map;
                                    Object v2 = AlternateFormStatType.REGISTRY.get((String)k);
                                    JsonElement jsonElement3 = v;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"v");
                                    map2.put(v2, Float.valueOf(jsonElement3.getAsFloat()));
                                }
                                JsonElement jsonElement4 = obj.get("level");
                                ((Map)formStats.getStatModifiers()).put(jsonElement4 != null ? Integer.valueOf(jsonElement4.getAsInt()) : Integer.valueOf(0), map);
                            }
                        }
                        ((Map)statMap).put(form, formStats);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (RuntimeException exception) {
                LOGGER.error("Couldn't parse alternate form stats " + key + " from " + location, (Throwable)exception);
            }
        }
        return statMap;
    }

    @Override
    protected void apply(@NotNull Map<AlternateForm, AlternateForm.Stats> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)resourceManager, (String)"resourceManager");
        stats = value;
        LOGGER.info("Loaded " + stats.size() + " alternate form stats");
        WitcheryNetworkChannel.sendToAll(new PacketUpdateAlternateFormStats(stats));
    }

    public final void deserializeStats(@NotNull Map<AlternateForm, AlternateForm.Stats> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        stats = map;
    }

    private AlternateFormStatManager() {
    }

    static {
        AlternateFormStatManager alternateFormStatManager;
        INSTANCE = alternateFormStatManager = new AlternateFormStatManager();
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(AlternateFormStatManager.class).getSimpleName()));
        boolean bl = false;
        stats = new LinkedHashMap();
    }
}

