/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.registry;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.registry.RegistrySupplier;
import net.msrandom.witchery.registry.WitcheryContentRegistrar;

public class ForgePlatformRegistryHandler<T extends IForgeRegistryEntry<T>> {
    private final Map<RegistrySupplier<ResourceLocation, ? extends T>, Function0<T>> values;
    private final IForgeRegistry<T> registry;

    public ForgePlatformRegistryHandler(Map<RegistrySupplier<ResourceLocation, ? extends T>, Function0<T>> values, IForgeRegistry<T> registry) {
        this.values = values;
        this.registry = registry;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void register(RegistryEvent.Register event) {
        if (event.getGenericType() == this.registry.getRegistrySuperType()) {
            this.handle(event);
        }
    }

    protected void handle(RegistryEvent.Register<T> event) {
        for (Map.Entry<RegistrySupplier<ResourceLocation, T>, Function0<T>> entry2 : this.values.entrySet()) {
            IForgeRegistryEntry value = (IForgeRegistryEntry)entry2.getValue().invoke();
            event.getRegistry().register(this.createName(entry2.getKey().getRegistryKey(), value));
            entry2.getKey().update();
        }
    }

    protected T createName(ResourceLocation name2, T value) {
        return (T)((IForgeRegistryEntry)value.setRegistryName(name2));
    }

    static class RegistryFinalizer<T extends IForgeRegistryEntry<T>> {
        private static final String FORGE_NAME = ((ModContainer)Loader.instance().getIndexedModList().get("forge")).getName();
        private final IForgeRegistry<T> registry;
        private final Set<WitcheryContentRegistrar<ResourceLocation, ?>> deferredRegistrars = new HashSet();

        RegistryFinalizer(IForgeRegistry<T> registry) {
            this.registry = registry;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void register(RegistryEvent.Register event) {
            if (event.getGenericType() == this.registry.getRegistrySuperType()) {
                int sum = 0;
                for (WitcheryContentRegistrar<ResourceLocation, ?> deferredRegistrar : this.deferredRegistrars) {
                    for (RegistrySupplier supplier2 : deferredRegistrar.values.keySet()) {
                        supplier2.update();
                        ++sum;
                    }
                }
                WitcheryResurrected.LOGGER.info("Updated {} {} owned {}s in {}", (Object)sum, (Object)FORGE_NAME, (Object)RegistrySupplier.class.getSimpleName(), (Object)event.getName());
            }
        }

        void add(WitcheryContentRegistrar<ResourceLocation, ?> registrar2) {
            this.deferredRegistrars.add(registrar2);
        }
    }
}

