/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/recipe/crafting/AddPotionsRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/minecraft/inventory/InventoryCrafting;", "id", "Lnet/minecraft/util/ResourceLocation;", "ingredient", "Lnet/minecraft/item/crafting/Ingredient;", "potion", "max", "", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/crafting/Ingredient;I)V", "getIngredient", "()Lnet/minecraft/item/crafting/Ingredient;", "getMax", "()I", "getPotion", "addPotions", "Lnet/minecraft/item/ItemStack;", "stack", "potionStack", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "getIngredients", "Lnet/minecraft/util/NonNullList;", "getRecipeOutput", "isDynamic", "Serializer", "WitcheryResurrected"})
public final class AddPotionsRecipe
extends WitcheryRecipe<InventoryCrafting> {
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final Ingredient potion;
    private final int max;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canCraft(@NotNull InventoryCrafting inventory, @Nullable World world) {
        Intrinsics.checkParameterIsNotNull((Object)inventory, (String)"inventory");
        boolean hasPotion = false;
        boolean hasItem = false;
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.getSizeInventory();
        while (n < n2) {
            ItemStack it;
            void i$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getStackInSlot((int)i$iv), (String)"getStackInSlot(i)");
            boolean bl = false;
            if (this.potion.test((Object)it)) {
                if (hasPotion || Intrinsics.areEqual((Object)PotionUtils.getPotionFromItem((ItemStack)it), (Object)PotionTypes.EMPTY)) {
                    return false;
                }
                hasPotion = true;
            } else if (this.ingredient.test((Object)it)) {
                if (hasItem) {
                    return false;
                }
                hasItem = true;
            } else if (!it.isEmpty()) {
                return false;
            }
            ++i$iv;
        }
        return hasItem && hasPotion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ItemStack craft(@NotNull InventoryCrafting inventory) {
        Intrinsics.checkParameterIsNotNull((Object)inventory, (String)"inventory");
        ItemStack stack = ItemStack.EMPTY;
        ItemStack potionStack = ItemStack.EMPTY;
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.getSizeInventory();
        while (n < n2) {
            ItemStack it;
            void i$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getStackInSlot((int)i$iv), (String)"getStackInSlot(i)");
            boolean bl = false;
            if (this.ingredient.test((Object)it)) {
                stack = it;
                ItemStack itemStack = potionStack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"potionStack");
                if (!itemStack.isEmpty()) {
                    ItemStack itemStack2 = stack;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stack");
                    ItemStack itemStack3 = potionStack;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"potionStack");
                    return this.addPotions(itemStack2, itemStack3);
                }
            } else if (this.potion.test((Object)it)) {
                potionStack = it;
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                if (!itemStack.isEmpty()) {
                    ItemStack itemStack4 = stack;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"stack");
                    ItemStack itemStack5 = potionStack;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack5, (String)"potionStack");
                    return this.addPotions(itemStack4, itemStack5);
                }
            }
            ++i$iv;
        }
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    private final ItemStack addPotions(ItemStack stack, ItemStack potionStack) {
        ItemStack itemStack;
        if (this.max == 1) {
            ItemStack itemStack2 = PotionUtils.addPotionToItemStack((ItemStack)stack.copy(), (PotionType)PotionUtils.getPotionFromItem((ItemStack)potionStack));
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"PotionUtils.addPotionToI\u2026ionFromItem(potionStack))");
        } else {
            ItemStack itemStack3 = stack.copy();
            List list2 = PotionUtils.getEffectsFromStack((ItemStack)stack);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"PotionUtils.getEffectsFromStack(stack)");
            Collection collection = list2;
            PotionType potionType = PotionUtils.getPotionFromItem((ItemStack)potionStack);
            Intrinsics.checkExpressionValueIsNotNull((Object)potionType, (String)"PotionUtils.getPotionFromItem(potionStack)");
            List list3 = potionType.getEffects();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"PotionUtils.getPotionFromItem(potionStack).effects");
            ItemStack result2 = PotionUtils.appendEffects((ItemStack)itemStack3, (Collection)CollectionsKt.plus((Collection)collection, (Iterable)list3));
            if (result2.hasTagCompound()) {
                ItemStack itemStack4 = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"result");
                NBTTagList tagList = WitcheryUtils.getOrCreateTag(itemStack4).getTagList("CustomPotionEffects", 10);
                if (tagList.tagCount() > this.max) {
                    tagList.removeTag(0);
                }
            }
            ItemStack itemStack5 = result2;
            itemStack = itemStack5;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack5, (String)"result");
        }
        return itemStack;
    }

    public boolean canFit(int width, int height2) {
        return width * height2 >= 2;
    }

    @NotNull
    public ItemStack getRecipeOutput() {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    public boolean isDynamic() {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonNullList = NonNullList.from((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient, this.potion});
        Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"NonNullList.from(Ingredi\u2026MPTY, ingredient, potion)");
        return nonNullList;
    }

    @NotNull
    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public final Ingredient getPotion() {
        return this.potion;
    }

    public final int getMax() {
        return this.max;
    }

    public AddPotionsRecipe(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, @NotNull Ingredient potion, int max) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        Intrinsics.checkParameterIsNotNull((Object)potion, (String)"potion");
        super(id, WitcheryRecipeSerializers.getAddPotions());
        this.ingredient = ingredient;
        this.potion = potion;
        this.max = max;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/recipe/crafting/AddPotionsRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/crafting/AddPotionsRecipe;", "()V", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<AddPotionsRecipe> {
        @Override
        @NotNull
        public AddPotionsRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            JsonElement jsonElement = json.get("ingredient");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json[\"ingredient\"]");
            Ingredient ingredient = WitcheryUtils.parseIngredient(jsonElement);
            JsonElement jsonElement2 = json.get("potion");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json[\"potion\"]");
            return new AddPotionsRecipe(id, ingredient, WitcheryUtils.parseIngredient(jsonElement2), JsonUtils.getInt((JsonObject)json, (String)"max", (int)1));
        }

        @Override
        @NotNull
        public AddPotionsRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            return new AddPotionsRecipe(id, WitcheryUtils.readIngredient(buffer), WitcheryUtils.readIngredient(buffer), buffer.readVarInt());
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull AddPotionsRecipe recipe) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)((Object)recipe), (String)"recipe");
            WitcheryUtils.writeIngredient(buffer, recipe.getIngredient());
            WitcheryUtils.writeIngredient(buffer, recipe.getPotion());
            buffer.writeVarInt(recipe.getMax());
        }
    }
}

