/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe.brazier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.recipe.RecipeType;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBrazier;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.util.WitcheryBookUtils;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000201B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010'\u001a\u00020!H\u0016J\b\u0010(\u001a\u00020\rH\u0016J \u0010)\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u00062"}, d2={"Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/msrandom/witchery/block/entity/TileEntityBrazier;", "id", "Lnet/minecraft/util/ResourceLocation;", "serializer", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "inputs", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "burnTime", "", "needsPower", "", "hidden", "(Lnet/minecraft/util/ResourceLocation;Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;Lnet/minecraft/util/NonNullList;IZZ)V", "getBurnTime", "()I", "getHidden", "()Z", "getNeedsPower", "addPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "canCraft", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "Lnet/minecraft/item/ItemStack;", "getDescription", "", "time", "", "getIngredients", "getRecipeOutput", "isDynamic", "onBurning", "position", "Lnet/minecraft/util/math/BlockPos;", "ticks", "", "onBurnt", "removePlayer", "BaseSerializer", "SimpleSerializer", "WitcheryResurrected"})
public abstract class BrazierRecipe
extends WitcheryRecipe<TileEntityBrazier> {
    private final NonNullList<Ingredient> inputs;
    private final int burnTime;
    private final boolean needsPower;
    private final boolean hidden;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canCraft(@NotNull TileEntityBrazier inventory, @Nullable World world) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory), (String)"inventory");
        ArrayList toFind = new ArrayList((Collection)this.inputs);
        Iterator iterator = toFind.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"toFind.iterator()");
        Iterator iterator2 = iterator;
        block0: while (iterator2.hasNext()) {
            Ingredient ingredient = (Ingredient)iterator2.next();
            int n = 0;
            int n2 = inventory.getSizeInventory();
            while (n < n2) {
                void i;
                if (ingredient.test((Object)inventory.getStackInSlot((int)i))) {
                    iterator2.remove();
                    continue block0;
                }
                ++i;
            }
        }
        return toFind.isEmpty();
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull TileEntityBrazier inventory) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory), (String)"inventory");
        return this.getRecipeOutput();
    }

    public boolean canFit(int width, int height2) {
        return this.inputs.size() <= width * height2;
    }

    @NotNull
    public ItemStack getRecipeOutput() {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean isDynamic() {
        return true;
    }

    public void addPlayer(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
    }

    public void removePlayer(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
    }

    public int onBurning(@NotNull World world, @NotNull BlockPos position, long ticks) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return 0;
    }

    public void onBurnt(@NotNull World world, @NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
    }

    @NotNull
    public final String getDescription(float time) {
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder().append("recipe.").append(this.getId().getNamespace()).append('.');
        String string = this.getId().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.path");
        String key = stringBuilder.append(StringsKt.replace$default((String)string, (String)"/", (String)".", (boolean)false, (int)4, null)).toString();
        String descriptionKey = key + ".description";
        sb.append(TextFormatting.UNDERLINE);
        sb.append(I18n.format((String)key, (Object[])new Object[0]));
        sb.append(TextFormatting.RESET);
        sb.append("\n\n");
        String description = I18n.format((String)descriptionKey, (Object[])new Object[0]);
        if (Intrinsics.areEqual((Object)description, (Object)descriptionKey) ^ true) {
            sb.append(description);
            sb.append("\n\n");
        }
        for (Ingredient ingredient : this.inputs) {
            sb.append(TextFormatting.DARK_GRAY).append(">").append(TextFormatting.BLACK).append(" ");
            Ingredient ingredient2 = ingredient;
            Intrinsics.checkExpressionValueIsNotNull((Object)ingredient2, (String)"ingredient");
            sb.append(WitcheryBookUtils.INSTANCE.getCurrentName(ingredient2, time));
            sb.append("\n");
        }
        String string2 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public final int getBurnTime() {
        return this.burnTime;
    }

    public final boolean getNeedsPower() {
        return this.needsPower;
    }

    public final boolean getHidden() {
        return this.hidden;
    }

    public BrazierRecipe(@NotNull ResourceLocation id, @NotNull WitcheryRecipeSerializer<?> serializer, @NotNull NonNullList<Ingredient> inputs, int burnTime, boolean needsPower, boolean hidden) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        super(id, serializer);
        this.inputs = inputs;
        this.burnTime = burnTime;
        this.needsPower = needsPower;
        this.hidden = hidden;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJC\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJC\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe$BaseSerializer;", "T", "Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "()V", "type", "Lnet/minecraft/recipe/RecipeType;", "getType", "()Lnet/minecraft/recipe/RecipeType;", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "(Lnet/minecraft/util/ResourceLocation;Lcom/google/gson/JsonObject;)Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "ingredients", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "burnTime", "", "needsPower", "", "hidden", "(Lnet/minecraft/util/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraft/util/NonNullList;IZZ)Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/network/PacketBuffer;)Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/network/PacketBuffer;Lnet/minecraft/util/NonNullList;IZZ)Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "write", "", "recipe", "(Lnet/minecraft/network/PacketBuffer;Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;)V", "WitcheryResurrected"})
    public static abstract class BaseSerializer<T extends BrazierRecipe>
    implements WitcheryRecipeSerializer<T> {
        @Override
        @NotNull
        public RecipeType<BrazierRecipe> getType() {
            return WitcheryRecipeTypes.BRAZIER;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final T read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            void var13_13;
            void destination$iv;
            void $this$mapTo$iv;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            JsonArray jsonArray = json.getAsJsonArray("ingredients");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"json.getAsJsonArray(\"ingredients\")");
            Iterable iterable = (Iterable)jsonArray;
            Collection collection = (Collection)NonNullList.create();
            JsonObject jsonObject = json;
            ResourceLocation resourceLocation = id;
            BaseSerializer baseSerializer = this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p1;
                JsonElement jsonElement = (JsonElement)item$iv;
                var13_13 = destination$iv;
                boolean bl = false;
                Ingredient ingredient = WitcheryUtils.parseIngredient((JsonElement)p1);
                var13_13.add(ingredient);
            }
            void v1 = var13_13 = destination$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"json.getAsJsonArray(\"ing\u2026ate(), ::parseIngredient)");
            return baseSerializer.read(resourceLocation, jsonObject, (NonNullList<Ingredient>)((NonNullList)v1), JsonUtils.getInt((JsonObject)json, (String)"burn_time", (int)6000), JsonUtils.getBoolean((JsonObject)json, (String)"needs_power", (boolean)true), JsonUtils.getBoolean((JsonObject)json, (String)"hidden", (boolean)false));
        }

        @NotNull
        public abstract T read(@NotNull ResourceLocation var1, @NotNull JsonObject var2, @NotNull NonNullList<Ingredient> var3, int var4, boolean var5, boolean var6);

        @Override
        @NotNull
        public final T read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Object[] objectArray;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            int n = buffer.readVarInt();
            PacketBuffer packetBuffer = buffer;
            ResourceLocation resourceLocation = id;
            BaseSerializer baseSerializer = this;
            Object[] objectArray2 = new Ingredient[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                objectArray = objectArray2;
                boolean bl = false;
                Ingredient ingredient = WitcheryUtils.readIngredient(buffer);
                objectArray[n4] = ingredient;
            }
            objectArray = objectArray2;
            Collection collection = ArraysKt.toCollection((Object[])objectArray, (Collection)((Collection)NonNullList.create()));
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"Array(buffer.readVarInt(\u2026ion(NonNullList.create())");
            return baseSerializer.read(resourceLocation, packetBuffer, (NonNullList<Ingredient>)((NonNullList)collection), buffer.readVarInt(), buffer.readBoolean(), buffer.readBoolean());
        }

        @NotNull
        public abstract T read(@NotNull ResourceLocation var1, @NotNull PacketBuffer var2, @NotNull NonNullList<Ingredient> var3, int var4, boolean var5, boolean var6);

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull T recipe) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(recipe, (String)"recipe");
            buffer.writeVarInt(((BrazierRecipe)recipe).inputs.size());
            Iterator iterator = ((BrazierRecipe)recipe).inputs.iterator();
            while (iterator.hasNext()) {
                Ingredient input;
                Ingredient ingredient = input = (Ingredient)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"input");
                WitcheryUtils.writeIngredient(buffer, ingredient);
            }
            buffer.writeVarInt(((BrazierRecipe)((Object)recipe)).getBurnTime());
            buffer.writeBoolean(((BrazierRecipe)((Object)recipe)).getNeedsPower());
            buffer.writeBoolean(((BrazierRecipe)((Object)recipe)).getHidden());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0082\u0001\u0012{\u0010\u0004\u001aw\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0012JC\u0010\u0013\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0016JC\u0010\u0013\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0019R\u0083\u0001\u0010\u0004\u001aw\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe$SimpleSerializer;", "T", "Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe$BaseSerializer;", "factory", "Lkotlin/Function5;", "Lnet/minecraft/util/ResourceLocation;", "Lkotlin/ParameterName;", "name", "id", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "ingredients", "", "burnTime", "", "needsPower", "hidden", "(Lkotlin/jvm/functions/Function5;)V", "read", "json", "Lcom/google/gson/JsonObject;", "(Lnet/minecraft/util/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraft/util/NonNullList;IZZ)Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/network/PacketBuffer;Lnet/minecraft/util/NonNullList;IZZ)Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "WitcheryResurrected"})
    public static final class SimpleSerializer<T extends BrazierRecipe>
    extends BaseSerializer<T> {
        private final Function5<ResourceLocation, NonNullList<Ingredient>, Integer, Boolean, Boolean, T> factory;

        @Override
        @NotNull
        public T read(@NotNull ResourceLocation id, @NotNull JsonObject json, @NotNull NonNullList<Ingredient> ingredients, int burnTime, boolean needsPower, boolean hidden) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull(ingredients, (String)"ingredients");
            return (T)((Object)((BrazierRecipe)((Object)this.factory.invoke((Object)id, ingredients, (Object)burnTime, (Object)needsPower, (Object)hidden))));
        }

        @Override
        @NotNull
        public T read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer, @NotNull NonNullList<Ingredient> ingredients, int burnTime, boolean needsPower, boolean hidden) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(ingredients, (String)"ingredients");
            return (T)((Object)((BrazierRecipe)((Object)this.factory.invoke((Object)id, ingredients, (Object)burnTime, (Object)needsPower, (Object)hidden))));
        }

        public SimpleSerializer(@NotNull Function5<? super ResourceLocation, ? super NonNullList<Ingredient>, ? super Integer, ? super Boolean, ? super Boolean, ? extends T> factory2) {
            Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
            this.factory = factory2;
        }
    }
}

