/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntitySpinningWheel;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.recipe.WitcheryRecipeType;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\b\u0010 \u001a\u00020\u0006H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/recipe/SpinningWheelRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/msrandom/witchery/block/entity/TileEntitySpinningWheel;", "id", "Lnet/minecraft/util/ResourceLocation;", "result", "Lnet/minecraft/item/ItemStack;", "fibre", "Lnet/minecraft/item/crafting/Ingredient;", "fibreCount", "", "modifiers", "Lnet/minecraft/util/NonNullList;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/crafting/Ingredient;ILnet/minecraft/util/NonNullList;)V", "getFibre", "()Lnet/minecraft/item/crafting/Ingredient;", "getFibreCount", "()I", "getModifiers", "()Lnet/minecraft/util/NonNullList;", "getResult", "()Lnet/minecraft/item/ItemStack;", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "getIngredients", "getRecipeOutput", "Serializer", "WitcheryResurrected"})
public final class SpinningWheelRecipe
extends WitcheryRecipe<TileEntitySpinningWheel> {
    @NotNull
    private final ItemStack result;
    @NotNull
    private final Ingredient fibre;
    private final int fibreCount;
    @NotNull
    private final NonNullList<Ingredient> modifiers;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canCraft(@NotNull TileEntitySpinningWheel inventory, @Nullable World world) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)((Object)inventory), (String)"inventory");
                ItemStack inventoryFibre = inventory.getStackInSlot(0);
                if (!this.fibre.test((Object)inventoryFibre)) break block6;
                ItemStack itemStack = inventoryFibre;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventoryFibre");
                if (itemStack.getCount() >= this.fibreCount) break block7;
            }
            return false;
        }
        for (Ingredient modifier : this.modifiers) {
            boolean found = false;
            int n = 1;
            int n2 = 3;
            while (n <= n2) {
                void i;
                if (modifier.test((Object)inventory.getStackInSlot((int)i))) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull TileEntitySpinningWheel inventory) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory), (String)"inventory");
        ItemStack itemStack = this.result.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"result.copy()");
        return itemStack;
    }

    public boolean canFit(int width, int height2) {
        return true;
    }

    @NotNull
    public ItemStack getRecipeOutput() {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonNullList = NonNullList.from((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.fibre});
        boolean bl = false;
        boolean bl2 = false;
        NonNullList it = nonNullList;
        boolean bl3 = false;
        for (Ingredient modifier : this.modifiers) {
            it.add((Object)modifier);
        }
        NonNullList nonNullList2 = nonNullList;
        Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList2, (String)"NonNullList.from(Ingredi\u2026modifier)\n        }\n    }");
        return nonNullList2;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public final Ingredient getFibre() {
        return this.fibre;
    }

    public final int getFibreCount() {
        return this.fibreCount;
    }

    @NotNull
    public final NonNullList<Ingredient> getModifiers() {
        return this.modifiers;
    }

    public SpinningWheelRecipe(@NotNull ResourceLocation id, @NotNull ItemStack result2, @NotNull Ingredient fibre, int fibreCount, @NotNull NonNullList<Ingredient> modifiers) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)fibre, (String)"fibre");
        Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
        super(id, WitcheryRecipeTypes.SPINNING_WHEEL.getSerializer());
        this.result = result2;
        this.fibre = fibre;
        this.fibreCount = fibreCount;
        this.modifiers = modifiers;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/witchery/recipe/SpinningWheelRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/SpinningWheelRecipe;", "()V", "type", "Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "getType", "()Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<SpinningWheelRecipe> {
        @NotNull
        public WitcheryRecipeType<SpinningWheelRecipe> getType() {
            return WitcheryRecipeTypes.SPINNING_WHEEL;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SpinningWheelRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            JsonArray jsonArray;
            int n;
            Ingredient ingredient;
            ItemStack itemStack;
            ResourceLocation resourceLocation;
            block4: {
                block3: {
                    void var17_15;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                    Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
                    JsonObject fibre = json.getAsJsonObject("fibre");
                    resourceLocation = id;
                    JsonObject jsonObject = json.getAsJsonObject("result");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getAsJsonObject(\"result\")");
                    itemStack = WitcheryUtils.parseStack(jsonObject);
                    JsonElement jsonElement = fibre.get("ingredient");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"fibre[\"ingredient\"]");
                    ingredient = WitcheryUtils.parseIngredient(jsonElement);
                    n = JsonUtils.getInt((JsonObject)fibre, (String)"count", (int)1);
                    jsonArray = json.getAsJsonArray("modifiers");
                    if (jsonArray == null) break block3;
                    Iterable iterable = (Iterable)jsonArray;
                    Collection collection = (Collection)NonNullList.create();
                    int n2 = n;
                    Ingredient ingredient2 = ingredient;
                    ItemStack itemStack2 = itemStack;
                    ResourceLocation resourceLocation2 = resourceLocation;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void p1;
                        JsonElement jsonElement2 = (JsonElement)item$iv;
                        var17_15 = destination$iv;
                        boolean bl = false;
                        Ingredient ingredient3 = WitcheryUtils.parseIngredient((JsonElement)p1);
                        var17_15.add(ingredient3);
                    }
                    var17_15 = destination$iv;
                    resourceLocation = resourceLocation2;
                    itemStack = itemStack2;
                    ingredient = ingredient2;
                    n = n2;
                    jsonArray = (NonNullList)var17_15;
                    if (jsonArray != null) break block4;
                }
                NonNullList nonNullList = NonNullList.from((Object)Ingredient.EMPTY, (Object[])new Ingredient[0]);
                jsonArray = nonNullList;
                Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"NonNullList.from(Ingredient.EMPTY)");
            }
            JsonArray jsonArray2 = jsonArray;
            int n3 = n;
            Ingredient ingredient4 = ingredient;
            ItemStack itemStack3 = itemStack;
            ResourceLocation resourceLocation3 = resourceLocation;
            return new SpinningWheelRecipe(resourceLocation3, itemStack3, ingredient4, n3, (NonNullList<Ingredient>)jsonArray2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SpinningWheelRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            NonNullList nonNullList;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            ItemStack itemStack = buffer.readItemStack();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"buffer.readItemStack()");
            NonNullList nonNullList2 = NonNullList.withSize((int)buffer.readVarInt(), (Object)Ingredient.EMPTY);
            int n = buffer.readVarInt();
            Ingredient ingredient = WitcheryUtils.readIngredient(buffer);
            ItemStack itemStack2 = itemStack;
            ResourceLocation resourceLocation = id;
            boolean bl = false;
            boolean bl2 = false;
            NonNullList it = nonNullList2;
            boolean bl3 = false;
            int n2 = 0;
            NonNullList nonNullList3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList3, (String)"it");
            int n3 = ((Collection)nonNullList3).size();
            while (n2 < n3) {
                void index;
                it.set((int)index, (Object)WitcheryUtils.readIngredient(buffer));
                ++index;
            }
            NonNullList nonNullList4 = nonNullList = nonNullList2;
            Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList4, (String)"NonNullList.withSize(buf\u2026      }\n                }");
            NonNullList nonNullList5 = nonNullList4;
            int n4 = n;
            Ingredient ingredient2 = ingredient;
            ItemStack itemStack3 = itemStack2;
            ResourceLocation resourceLocation2 = resourceLocation;
            return new SpinningWheelRecipe(resourceLocation2, itemStack3, ingredient2, n4, (NonNullList<Ingredient>)nonNullList5);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull SpinningWheelRecipe recipe) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)((Object)recipe), (String)"recipe");
            buffer.writeItemStack(recipe.getResult());
            WitcheryUtils.writeIngredient(buffer, recipe.getFibre());
            buffer.writeVarInt(recipe.getFibreCount());
            buffer.writeVarInt(recipe.getModifiers().size());
            Iterator iterator = recipe.getModifiers().iterator();
            while (iterator.hasNext()) {
                Ingredient modifier;
                Ingredient ingredient = modifier = (Ingredient)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"modifier");
                WitcheryUtils.writeIngredient(buffer, ingredient);
            }
        }
    }
}

