/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.RecipeMatcher;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.entity.TileEntityKettle;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.recipe.WitcheryRecipeType;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lnet/msrandom/witchery/recipe/KettleRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/msrandom/witchery/block/entity/TileEntityKettle;", "id", "Lnet/minecraft/util/ResourceLocation;", "result", "Lnet/minecraft/item/ItemStack;", "inputs", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "hatBonus", "", "familiarPower", "powerRequired", "", "dimension", "Lnet/minecraft/world/DimensionType;", "special", "", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/NonNullList;ILnet/minecraft/util/ResourceLocation;FLnet/minecraft/world/DimensionType;Z)V", "getFamiliarPower", "()Lnet/minecraft/util/ResourceLocation;", "getHatBonus", "()I", "getInputs", "()Lnet/minecraft/util/NonNullList;", "getPowerRequired", "()F", "getSpecial", "()Z", "canCraft", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "getRecipeOutput", "Serializer", "WitcheryResurrected"})
public final class KettleRecipe
extends WitcheryRecipe<TileEntityKettle> {
    private final ItemStack result;
    @NotNull
    private final NonNullList<Ingredient> inputs;
    private final int hatBonus;
    @Nullable
    private final ResourceLocation familiarPower;
    private final float powerRequired;
    private final DimensionType dimension;
    private final boolean special;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canCraft(@NotNull TileEntityKettle inventory, @Nullable World world) {
        World world2;
        Intrinsics.checkParameterIsNotNull((Object)inventory, (String)"inventory");
        if (this.dimension == null || ((world2 = world) != null && (world2 = world2.provider) != null ? world2.getDimensionType() : null) == this.dimension) {
            ArrayList inputsToFind = new ArrayList((Collection)this.inputs);
            for (int j = 0; j < 7; ++j) {
                ItemStack stack = inventory.getStackInSlot(j);
                boolean foundOne = false;
                int n = 0;
                int n2 = ((Collection)inputsToFind).size();
                while (n < n2) {
                    void i;
                    Ingredient input = (Ingredient)inputsToFind.get((int)i);
                    if (input.test((Object)stack)) {
                        inputsToFind.remove((int)i);
                        foundOne = true;
                        break;
                    }
                    ++i;
                }
                if (foundOne) continue;
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                if (itemStack.isEmpty()) break;
                return false;
            }
            return inputsToFind.size() <= this.inputs.size();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ItemStack craft(@NotNull TileEntityKettle inventory) {
        Intrinsics.checkParameterIsNotNull((Object)inventory, (String)"inventory");
        int n = 0;
        List found = new ArrayList();
        n = 0;
        int n2 = 6;
        while (n < n2) {
            void i;
            ItemStack stack;
            ItemStack itemStack = stack = inventory.getStackInSlot((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (itemStack.isEmpty()) {
                ItemStack itemStack2 = ItemStack.EMPTY;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
                return itemStack2;
            }
            found.add(stack);
            ++i;
        }
        if (RecipeMatcher.findMatches((List)found, (List)((List)this.inputs)) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
            return itemStack;
        }
        ItemStack itemStack = this.result.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"result.copy()");
        return itemStack;
    }

    public boolean canFit(int width, int height2) {
        return this.inputs.size() <= RangesKt.coerceAtMost((int)(width * height2), (int)6);
    }

    @NotNull
    public ItemStack getRecipeOutput() {
        return this.result;
    }

    @NotNull
    public final NonNullList<Ingredient> getInputs() {
        return this.inputs;
    }

    public final int getHatBonus() {
        return this.hatBonus;
    }

    @Nullable
    public final ResourceLocation getFamiliarPower() {
        return this.familiarPower;
    }

    public final float getPowerRequired() {
        return this.powerRequired;
    }

    public final boolean getSpecial() {
        return this.special;
    }

    public KettleRecipe(@NotNull ResourceLocation id, @NotNull ItemStack result2, @NotNull NonNullList<Ingredient> inputs, int hatBonus, @Nullable ResourceLocation familiarPower, float powerRequired, @Nullable DimensionType dimension, boolean special) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        super(id, WitcheryRecipeTypes.KETTLE.getSerializer());
        this.result = result2;
        this.inputs = inputs;
        this.hatBonus = hatBonus;
        this.familiarPower = familiarPower;
        this.powerRequired = powerRequired;
        this.dimension = dimension;
        this.special = special;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/witchery/recipe/KettleRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/KettleRecipe;", "()V", "type", "Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "getType", "()Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<KettleRecipe> {
        @NotNull
        public WitcheryRecipeType<KettleRecipe> getType() {
            return WitcheryRecipeTypes.KETTLE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public KettleRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            DimensionType dimensionType;
            ResourceLocation resourceLocation;
            void $this$mapTo$iv;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            JsonObject jsonObject = json.getAsJsonObject("result");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getAsJsonObject(\"result\")");
            ItemStack result2 = WitcheryUtils.parseStack(jsonObject);
            JsonElement jsonElement = json.get("hat_bonus");
            int hatBonus = jsonElement != null ? jsonElement.getAsInt() : 0;
            JsonElement jsonElement2 = json.get("power_required");
            float powerRequired = jsonElement2 != null ? jsonElement2.getAsFloat() : 0.0f;
            JsonArray jsonArray = json.getAsJsonArray("ingredients");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"json.getAsJsonArray(\"ingredients\")");
            Iterable iterable = (Iterable)jsonArray;
            Collection destination$iv = (Collection)NonNullList.create();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p1;
                JsonElement jsonElement3 = (JsonElement)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Ingredient ingredient = WitcheryUtils.parseIngredient((JsonElement)p1);
                collection.add(ingredient);
            }
            NonNullList inputs = (NonNullList)destination$iv;
            Object object = json.get("familiar_power");
            if (object != null && (object = object.getAsString()) != null) {
                destination$iv = object;
                $i$f$mapTo2 = false;
                boolean bl = false;
                Collection p1 = destination$iv;
                boolean bl2 = false;
                resourceLocation = new ResourceLocation((String)((Object)p1));
            } else {
                resourceLocation = null;
            }
            ResourceLocation familiar = resourceLocation;
            JsonElement jsonElement4 = json.get("dimension");
            if (jsonElement4 != null) {
                JsonElement $i$f$mapTo2 = jsonElement4;
                boolean bl = false;
                boolean bl3 = false;
                JsonElement it = $i$f$mapTo2;
                boolean bl4 = false;
                dimensionType = WitcheryResurrected.Companion.getDIMENSION_MAP().get(it.getAsString());
            } else {
                dimensionType = null;
            }
            DimensionType dimension = dimensionType;
            JsonElement jsonElement5 = json.get("special");
            boolean special = jsonElement5 != null && jsonElement5.getAsBoolean();
            NonNullList nonNullList = inputs;
            Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"inputs");
            return new KettleRecipe(id, result2, (NonNullList<Ingredient>)nonNullList, hatBonus, familiar, powerRequired, dimension, special);
        }

        @Override
        @NotNull
        public KettleRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Object[] objectArray;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            boolean bl = false;
            boolean bl2 = false;
            PacketBuffer $this$with = buffer;
            boolean bl3 = false;
            ItemStack itemStack = $this$with.readItemStack();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"readItemStack()");
            int n = $this$with.readVarInt();
            ItemStack itemStack2 = itemStack;
            ResourceLocation resourceLocation = id;
            Object[] objectArray2 = new Ingredient[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                objectArray = objectArray2;
                boolean bl4 = false;
                Ingredient ingredient = WitcheryUtils.readIngredient($this$with);
                objectArray[n4] = ingredient;
            }
            objectArray = objectArray2;
            Collection collection = ArraysKt.toCollection((Object[])objectArray, (Collection)((Collection)NonNullList.create()));
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"Array(readVarInt()) { re\u2026ion(NonNullList.create())");
            boolean bl5 = $this$with.readBoolean();
            DimensionType dimensionType = $this$with.readBoolean() ? DimensionManager.getProviderType((int)$this$with.readVarInt()) : null;
            float f = $this$with.readFloat();
            ResourceLocation resourceLocation2 = $this$with.readBoolean() ? buffer.readResourceLocation() : null;
            int n5 = $this$with.readVarInt();
            NonNullList nonNullList = (NonNullList)collection;
            ItemStack itemStack3 = itemStack2;
            ResourceLocation resourceLocation3 = resourceLocation;
            return new KettleRecipe(resourceLocation3, itemStack3, (NonNullList<Ingredient>)nonNullList, n5, resourceLocation2, f, dimensionType, bl5);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull KettleRecipe recipe) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)((Object)recipe), (String)"recipe");
            boolean bl = false;
            boolean bl2 = false;
            PacketBuffer $this$with = buffer;
            boolean bl3 = false;
            $this$with.writeItemStack(recipe.result);
            $this$with.writeVarInt(recipe.getInputs().size());
            Iterator iterator = recipe.getInputs().iterator();
            while (iterator.hasNext()) {
                Ingredient input;
                Ingredient ingredient = input = (Ingredient)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"input");
                WitcheryUtils.writeIngredient(buffer, ingredient);
            }
            $this$with.writeVarInt(recipe.getHatBonus());
            if (recipe.getFamiliarPower() == null) {
                $this$with.writeBoolean(false);
            } else {
                $this$with.writeBoolean(true);
                $this$with.writeResourceLocation(recipe.getFamiliarPower());
            }
            $this$with.writeFloat(recipe.getPowerRequired());
            if (recipe.dimension == null) {
                $this$with.writeBoolean(false);
            } else {
                $this$with.writeBoolean(true);
                $this$with.writeVarInt(recipe.dimension.getId());
            }
            $this$with.writeBoolean(recipe.getSpecial());
        }
    }
}

