/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.block.BlockWitchCrop;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.recipe.brazier.BrazierRecipe;
import net.msrandom.witchery.util.CreatureUtil;
import org.jetbrains.annotations.NotNull;

public class BrazierDrainGrowthRecipe
extends BrazierRecipe {
    public BrazierDrainGrowthRecipe(@NotNull ResourceLocation id, @NotNull NonNullList<Ingredient> inputs, int burnTime, boolean needsPower, boolean hidden) {
        super(id, WitcheryRecipeSerializers.getBrazierDrainGrowth(), inputs, burnTime, needsPower, hidden);
    }

    @Override
    public int onBurning(World world, BlockPos pos, long ticks) {
        if (ticks % 5L == 0L) {
            int offsetY = (int)(ticks % 30L) / 5;
            int radius = 3;
            BlockPos p = pos.add(world.rand.nextInt(7) - radius, offsetY - 2, world.rand.nextInt(7) - radius);
            IBlockState state = world.getBlockState(pos);
            if (state.getBlock() instanceof IPlantable) {
                IBlockState currentState;
                IPlantable plantable = (IPlantable)state;
                if ((state instanceof BlockWitchCrop || plantable.getPlantType((IBlockAccess)world, p) == EnumPlantType.Crop) && (currentState = plantable.getPlant((IBlockAccess)world, p)) != state.getBlock().getDefaultState()) {
                    world.setBlockState(p, state.getBlock().getDefaultState());
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 0.3f, 0.5f, EnumParticleTypes.SPELL_MOB), world, pos.up(), 8.0);
                    this.healNearbyUndead(world, p, radius);
                    return 2;
                }
            }
        }
        return 0;
    }

    private void healNearbyUndead(World world, BlockPos pos, int radius) {
        AxisAlignedBB bb = new AxisAlignedBB(pos.add(-radius, -radius, -radius), pos.add(radius, radius, radius));
        List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, bb);
        for (EntityLivingBase entity : entities) {
            if (!CreatureUtil.isUndead((Entity)entity)) continue;
            float maxHealth = entity.getMaxHealth();
            if (entity.getHealth() >= maxHealth) continue;
            entity.heal(maxHealth * 0.1f);
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 1.0f, EnumParticleTypes.HEART), (Entity)entity);
        }
    }
}

