/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.util.WitcheryUtils;

public class PredictionWet
extends Prediction {
    private final int depth;

    public PredictionWet(int weight, String translationKey, int depth) {
        super(weight, translationKey);
        this.depth = depth;
    }

    @Override
    public boolean doSelfFulfillment(EntityPlayer player) {
        int RADIUS = 1;
        int x0 = MathHelper.floor((double)player.posX);
        int y0 = MathHelper.floor((double)player.posY) - RADIUS;
        int z0 = MathHelper.floor((double)player.posZ);
        World world = player.world;
        if (!world.isRemote && y0 > 5 && !world.provider.isNether()) {
            int z2;
            int x2;
            int dirtCount = 0;
            for (x2 = x0 - RADIUS; x2 <= x0 + RADIUS; ++x2) {
                for (z2 = z0 - RADIUS; z2 <= z0 + RADIUS; ++z2) {
                    Material material = world.getBlockState(new BlockPos(x2, y0, z2)).getMaterial();
                    if (material != Material.GROUND && material != Material.GRASS) continue;
                    ++dirtCount;
                }
            }
            if (dirtCount == 9) {
                for (x2 = x0 - RADIUS; x2 <= x0 + RADIUS; ++x2) {
                    for (z2 = z0 - RADIUS; z2 <= z0 + RADIUS; ++z2) {
                        for (int y2 = y0; y2 > y0 - this.depth; --y2) {
                            BlockPos pos = new BlockPos(x2, y2, z2);
                            if (y2 == y0) {
                                world.setBlockState(pos, Blocks.GRAVEL.getDefaultState());
                                continue;
                            }
                            if (!WitcheryUtils.canBreak(world.getBlockState(pos))) continue;
                            world.setBlockState(pos, Blocks.WATER.getDefaultState());
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNormalFulfillment(World world, EntityPlayer player, boolean isPastDue) {
        return player.isWet();
    }
}

