/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.PredictionAlwaysForced;
import net.msrandom.witchery.prediction.PredictionSerializer;
import org.jetbrains.annotations.NotNull;

public class PredictionRescue<T extends EntityLiving>
extends PredictionAlwaysForced {
    private final Class<T> entityClass;
    private final Consumer<T> spawnAction;

    public PredictionRescue(int weight, String translationKey, int duration, Class<T> entityClass, Consumer<T> spawnAction) {
        super(weight, translationKey, duration);
        this.entityClass = entityClass;
        this.spawnAction = spawnAction;
    }

    @Override
    public boolean checkHurtFulfillment(World world, EntityPlayer player, DamageSource source) {
        Entity attackingEntity = source.getTrueSource();
        if (attackingEntity instanceof EntityLivingBase) {
            try {
                int x = MathHelper.floor((double)player.posX);
                int y = MathHelper.floor((double)player.posY);
                int z = MathHelper.floor((double)player.posZ);
                if (!world.isRemote) {
                    int hy;
                    int ny;
                    int MAX_DISTANCE = 4;
                    int activeRadius = 2;
                    int ax = world.rand.nextInt(activeRadius * 2 + 1);
                    if (ax > activeRadius) {
                        ax += MAX_DISTANCE;
                    }
                    int nx = x - MAX_DISTANCE + ax;
                    int az = world.rand.nextInt(activeRadius * 2 + 1);
                    if (az > activeRadius) {
                        az += MAX_DISTANCE;
                    }
                    int nz = z - MAX_DISTANCE + az;
                    for (ny = y; !world.isAirBlock(new BlockPos(nx, ny, nz)) && ny < y + 8; ++ny) {
                    }
                    while (world.isAirBlock(new BlockPos(nx, ny, nz)) && ny > 0) {
                        --ny;
                    }
                    for (hy = 0; world.isAirBlock(new BlockPos(nx, ny + hy + 1, nz)) && hy < 6; ++hy) {
                    }
                    Constructor<T> ctor = this.entityClass.getConstructor(World.class);
                    EntityLiving entity = (EntityLiving)ctor.newInstance(world);
                    if ((float)hy >= entity.height) {
                        entity.setLocationAndAngles(0.5 + (double)nx, 0.05 + (double)ny + 1.0, 0.5 + (double)nz, 0.0f, 0.0f);
                        world.spawnEntity((Entity)entity);
                        entity.onInitialSpawn(world.getDifficultyForLocation(entity.getPosition()), null);
                        if (this.spawnAction != null) {
                            this.spawnAction.accept(entity);
                        }
                        entity.setAttackTarget((EntityLivingBase)attackingEntity);
                        if (entity instanceof EntityCreature) {
                            entity.setRevengeTarget((EntityLivingBase)attackingEntity);
                        }
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)entity);
                        return true;
                    }
                    return false;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public static class Serializer
    implements PredictionSerializer<PredictionRescue<?>> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        @NotNull
        public PredictionRescue<?> read(int weight, String translationKey, @NotNull JsonObject json) {
            return new PredictionRescue(weight, translationKey, json.get("fulfillment_duration").getAsInt(), EntityList.getClass((ResourceLocation)new ResourceLocation(json.get("rescuer").getAsString())), null);
        }
    }
}

