/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.util.WitcheryUtils;

public class PredictionNetherTrip
extends Prediction {
    public PredictionNetherTrip(int weight, String translationKey) {
        super(weight, translationKey);
    }

    @Override
    public boolean isPredictionPossible(EntityPlayer player) {
        return player.dimension != -1 && WitcheryUtils.getExtension(player).hasVisitedNether();
    }

    @Override
    public boolean doSelfFulfillment(EntityPlayer player) {
        int RADIUS = 1;
        int x = MathHelper.floor((double)player.posX);
        int y = MathHelper.floor((double)player.posY) - RADIUS;
        int z = MathHelper.floor((double)player.posZ);
        if (!player.world.isRemote && player.dimension != -1) {
            int hy;
            int ny;
            player.sendMessage(new TextComponentTranslation("prediction.witchery.nether_trip.summoned", new Object[0]).setStyle(new Style().setColor(TextFormatting.LIGHT_PURPLE)));
            player.setPortal(player.getPosition());
            World world3 = player.world;
            int MAX_DISTANCE = 4;
            int MIN_DISTANCE = 2;
            int activeRadius = 2;
            int ax = world3.rand.nextInt(activeRadius * MIN_DISTANCE + RADIUS);
            if (ax > activeRadius) {
                ax += MAX_DISTANCE;
            }
            int nx = x - 4 + ax;
            int az = world3.rand.nextInt(activeRadius * MIN_DISTANCE + RADIUS);
            if (az > activeRadius) {
                az += MAX_DISTANCE;
            }
            int nz = z - 4 + az;
            for (ny = y; !world3.isAirBlock(new BlockPos(nx, ny, nz)) && ny < y + 8; ++ny) {
            }
            while (world3.isAirBlock(new BlockPos(nx, ny, nz)) && ny > 0) {
                --ny;
            }
            for (hy = 0; world3.isAirBlock(new BlockPos(nx, ny + hy + RADIUS, nz)) && hy < 6; ++hy) {
            }
            EntityBlaze entity = new EntityBlaze(world3);
            if ((float)hy >= entity.height) {
                entity.setLocationAndAngles((double)nx, (double)ny, (double)nz, 0.0f, 0.0f);
                world3.spawnEntity((Entity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkNormalFulfillment(World world, EntityPlayer player, boolean isPastDue) {
        return player.dimension == -1;
    }
}

