/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.prediction.PredictionSerializer;
import org.jetbrains.annotations.NotNull;

public class PredictionFight<T extends EntityLiving>
extends Prediction {
    private final Class<T> entityClass;
    private final String damage;
    private final BiConsumer<EntityPlayer, T> spawnAction;

    public PredictionFight(int weight, String translationKey, Class<T> entityClass, String damage, BiConsumer<EntityPlayer, T> spawnAction) {
        super(weight, translationKey);
        this.entityClass = entityClass;
        this.damage = damage;
        this.spawnAction = spawnAction;
    }

    @Override
    public boolean doSelfFulfillment(EntityPlayer player) {
        try {
            BlockPos pos = player.getPosition();
            World world = player.world;
            if (!world.isRemote) {
                int hy;
                int az;
                int radius = 2;
                int rangeSq = radius * radius;
                int ax = world.rand.nextInt(radius * 2 + 1);
                if (ax > radius) {
                    ax += rangeSq;
                }
                if ((az = world.rand.nextInt(radius * 2 + 1)) > radius) {
                    az += rangeSq;
                }
                BlockPos p = pos.add(ax - rangeSq, 0, az - rangeSq);
                while (!world.isAirBlock(p) && p.getY() < pos.getY() + 8) {
                    p = p.up();
                }
                while (world.isAirBlock(p) && p.getY() > 0) {
                    p = p.down();
                }
                for (hy = 0; world.isAirBlock(p.up(hy + 1)) && hy < 6; ++hy) {
                }
                Constructor<T> ctor = this.entityClass.getConstructor(World.class);
                EntityLiving entity = (EntityLiving)ctor.newInstance(world);
                if ((float)hy < entity.height) {
                    return false;
                }
                entity.setLocationAndAngles((double)p.getX() + 0.5, (double)p.getY() + 1.05, (double)p.getZ() + 0.5, 0.0f, 0.0f);
                entity.onInitialSpawn(world.getDifficultyForLocation(entity.getPosition()), null);
                this.spawnAction.accept(player, (EntityPlayer)entity);
                world.spawnEntity((Entity)entity);
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)entity);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean checkHurtFulfillment(World world, EntityPlayer player, DamageSource source) {
        if (this.damage == null) {
            Entity attackingEntity = source.getTrueSource();
            return attackingEntity != null && this.entityClass.isAssignableFrom(attackingEntity.getClass());
        }
        return source.damageType.equals(this.damage);
    }

    public static class Serializer<T extends EntityLiving>
    implements PredictionSerializer<PredictionFight<T>> {
        private final BiConsumer<EntityPlayer, T> spawnAction;

        public Serializer(BiConsumer<EntityPlayer, T> spawnAction) {
            this.spawnAction = spawnAction;
        }

        @Override
        @NotNull
        public PredictionFight<T> read(int weight, @NotNull String translationKey, @NotNull JsonObject json) {
            JsonElement element = json.get("damage_type");
            return new PredictionFight<T>(weight, translationKey, EntityList.getClass((ResourceLocation)new ResourceLocation(json.get("entity").getAsString())), element == null ? null : element.getAsString(), this.spawnAction);
        }
    }
}

