/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.ai.EntityAIMateWithPlayer;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.PredictionAlwaysForced;

public class PredictionFallInLove
extends PredictionAlwaysForced {
    public PredictionFallInLove(int weight, String translationKey, int duration) {
        super(weight, translationKey, duration);
    }

    @Override
    public boolean checkNormalFulfillment(World world, EntityPlayer player, boolean isPastDue) {
        int hy;
        int az;
        if (!this.shouldActivate(world, isPastDue)) {
            return false;
        }
        BlockPos pos = player.getPosition();
        int maxRange = 6;
        int activeRadius = 2;
        int ax = world.rand.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += 8;
        }
        if ((az = world.rand.nextInt(activeRadius * 2 + 1)) > activeRadius) {
            az += 8;
        }
        BlockPos p = pos.add(ax - maxRange, 0, az - maxRange);
        while (!world.isAirBlock(p) && p.getY() < pos.getY() + 8) {
            p = p.up();
        }
        while (world.isAirBlock(p) && p.getY() > 0) {
            p = p.down();
        }
        for (hy = 0; world.isAirBlock(p.up(hy + 1)) && hy < 6; ++hy) {
        }
        EntityVillager entity = new EntityVillager(world, 0);
        if ((float)hy >= entity.height && world.getBlockState(p.down()).isNormalCube()) {
            entity.setLocationAndAngles((double)p.getX() + 0.5, (double)p.getY() + 1.05, (double)p.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)entity);
            EntityAIMateWithPlayer task = new EntityAIMateWithPlayer(entity);
            task.forceTask(player);
            entity.tasks.addTask(1, (EntityAIBase)task);
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)entity);
            world.playSound(null, player.getPosition(), WitcherySounds.ENTITY_PLAYER_LOVED, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            return true;
        }
        return false;
    }
}

