/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.prediction.PredictionData;
import net.msrandom.witchery.resources.PredictionManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/prediction/Prediction;", "Lnet/minecraft/util/WeightedRandom$Item;", "weight", "", "translationKey", "", "(ILjava/lang/String;)V", "getTranslationKey", "()Ljava/lang/String;", "checkHarvestFulfillment", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "drops", "", "Lnet/minecraft/item/ItemStack;", "isPastDue", "veryOld", "checkHurtFulfillment", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "source", "Lnet/minecraft/util/DamageSource;", "checkNormalFulfillment", "doSelfFulfillment", "isPredictionPastDue", "ticks", "isPredictionPossible", "shouldTrySelfFulfill", "Companion", "WitcheryResurrected"})
public abstract class Prediction
extends WeightedRandom.Item {
    @NotNull
    private final String translationKey;
    public static final Companion Companion = new Companion(null);

    public boolean shouldTrySelfFulfill(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        return world.rand.nextDouble() * (double)100 < WitcheryConfigOptions.predictionForceFulfillmentProbability;
    }

    public boolean doSelfFulfillment(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        return false;
    }

    public boolean checkNormalFulfillment(@NotNull World world, @NotNull EntityPlayer player, boolean isPastDue) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        return false;
    }

    public boolean checkHurtFulfillment(@NotNull World world, @NotNull EntityPlayer player, @NotNull DamageSource source) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return false;
    }

    public boolean checkHarvestFulfillment(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull List<ItemStack> drops, boolean isPastDue, boolean veryOld) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(drops, (String)"drops");
        return false;
    }

    public boolean isPredictionPastDue(int ticks) {
        return ticks > 9600;
    }

    public boolean isPredictionPossible(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public final String getTranslationKey() {
        return this.translationKey;
    }

    public Prediction(int weight, @NotNull String translationKey) {
        Intrinsics.checkParameterIsNotNull((Object)translationKey, (String)"translationKey");
        super(weight);
        this.translationKey = translationKey;
    }

    @JvmStatic
    public static final void makePrediction(@NotNull EntityPlayer player, @NotNull EntityPlayer fortuneTeller, boolean sendChatMessage) {
        Companion.makePrediction(player, fortuneTeller, sendChatMessage);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lnet/msrandom/witchery/prediction/Prediction$Companion;", "", "()V", "makePrediction", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "fortuneTeller", "sendChatMessage", "", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        public final void makePrediction(@NotNull EntityPlayer player, @NotNull EntityPlayer fortuneTeller, boolean sendChatMessage) {
            block5: {
                boolean gotPrediction;
                block7: {
                    PlayerExtendedData playerEx;
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
                        Intrinsics.checkParameterIsNotNull((Object)fortuneTeller, (String)"fortuneTeller");
                        if (player.world.isRemote) break block5;
                        gotPrediction = false;
                        if (!player.capabilities.isCreativeMode && !WitcheryUtils.getExtension(fortuneTeller).isFortuneTeller()) {
                            player.sendMessage(new TextComponentTranslation("prediction.witchery.unskilled", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                            return;
                        }
                        playerEx = WitcheryUtils.getExtension(player);
                        if (!playerEx.predictions.isEmpty()) break block6;
                        boolean bl = false;
                        List possiblePredictions = new ArrayList();
                        Iterable $this$forEach$iv = PredictionManager.INSTANCE.getRegistry();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Map.Entry $dstr$_u24__u24$value = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            Object object = $dstr$_u24__u24$value;
                            boolean bl3 = false;
                            Prediction value = (Prediction)((Object)object.getValue());
                            if (!value.isPredictionPossible(player)) continue;
                            object = possiblePredictions;
                            bl3 = false;
                            object.add(value);
                        }
                        $this$forEach$iv = possiblePredictions;
                        boolean bl4 = false;
                        if (!(!$this$forEach$iv.isEmpty())) break block7;
                        Prediction prediction = (Prediction)WeightedRandom.getRandomItem((Random)player.world.rand, (List)possiblePredictions);
                        List<PredictionData> list2 = playerEx.predictions;
                        Prediction prediction2 = prediction;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)prediction2), (String)"prediction");
                        list2.add(new PredictionData(prediction2));
                        gotPrediction = true;
                        if (!sendChatMessage) break block7;
                        fortuneTeller.sendMessage(new TextComponentTranslation(prediction.getTranslationKey(), new Object[]{player.getName()}).setStyle(new Style().setColor(TextFormatting.LIGHT_PURPLE)));
                        break block7;
                    }
                    gotPrediction = true;
                    if (sendChatMessage) {
                        for (PredictionData value : playerEx.predictions) {
                            fortuneTeller.sendMessage(new TextComponentTranslation(value.getPrediction().getTranslationKey(), new Object[]{player.getName()}).setStyle(new Style().setColor(TextFormatting.LIGHT_PURPLE)));
                        }
                    }
                }
                if (!gotPrediction && sendChatMessage) {
                    fortuneTeller.sendMessage(new TextComponentTranslation("prediction.witchery.none", new Object[]{player.getName()}).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

