/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.potion.IHandleRenderLiving;

public class WitcheryPotion
extends Potion {
    private static final Map<Potion, ResourceLocation> TEXTURES = new HashMap<Potion, ResourceLocation>();
    protected boolean hideUnknownText;
    private boolean inventoryTextHidden;
    private boolean incurable;
    private boolean permanent;

    public WitcheryPotion(int color2) {
        this(false, color2);
    }

    public WitcheryPotion(boolean debuff, int color2) {
        super(debuff, color2);
    }

    public static boolean isDebuff(Potion potion) {
        return potion.isBadEffect();
    }

    public static boolean isCurable(Potion potion) {
        return !(potion instanceof WitcheryPotion) || ((WitcheryPotion)potion).isCurable();
    }

    public WitcheryPotion getPotion() {
        return this;
    }

    public boolean isCurable() {
        return !this.incurable;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setIncurable() {
        this.incurable = true;
    }

    public void setPermanent() {
        this.permanent = true;
    }

    protected void hideInventoryText() {
        this.inventoryTextHidden = true;
    }

    public void init() {
    }

    public void applyAttributesModifiersToEntity(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        super.applyAttributesModifiersToEntity(entity, attributes, amplifier);
        if (this instanceof IHandleRenderLiving) {
            PotionEffect effect = entity.getActivePotionEffect((Potion)this);
            for (EntityPlayer player : entity.world.playerEntities) {
                ((EntityPlayerMP)player).connection.sendPacket((Packet)new SPacketEntityEffect(entity.getEntityId(), effect));
            }
        }
    }

    public void removeAttributesModifiersFromEntity(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        super.removeAttributesModifiersFromEntity(entity, attributes, amplifier);
        if (this instanceof IHandleRenderLiving) {
            for (EntityPlayer player : entity.world.playerEntities) {
                ((EntityPlayerMP)player).connection.sendPacket((Packet)new SPacketRemoveEntityEffect(entity.getEntityId(), (Potion)this));
            }
        }
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return !this.inventoryTextHidden;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        if (this.inventoryTextHidden && !this.hideUnknownText) {
            Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(WitcheryResurrected.translate("effect.witchery.unknown", new Object[0]), (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
        }
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.getTexture());
        Gui.drawModalRectWithCustomSizedTexture((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.getTexture());
        Gui.drawModalRectWithCustomSizedTexture((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    private ResourceLocation getTexture() {
        return TEXTURES.computeIfAbsent(this, k -> {
            ResourceLocation id = (ResourceLocation)Potion.REGISTRY.getNameForObject(k);
            return new ResourceLocation(id.getNamespace(), "textures/mob_effect/" + id.getPath() + ".png");
        });
    }
}

