/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionWakingNightmare
extends WitcheryPotion
implements IHandleLivingUpdate {
    public PotionWakingNightmare(int color2) {
        super(true, color2);
        this.setPermanent();
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 20L == 3L && !WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)entity) && world.rand.nextInt(amplifier > 3 ? 30 : (amplifier > 1 ? 60 : 180)) == 0) {
            double R = 16.0;
            double H = 8.0;
            AxisAlignedBB bounds = new AxisAlignedBB(entity.posX - R, entity.posY - H, entity.posZ - R, entity.posX + R, entity.posY + H, entity.posZ + R);
            List entities = world.getEntitiesWithinAABB(EntityNightmare.class, bounds);
            boolean doNothing = false;
            for (EntityNightmare nightmare : entities) {
                if (!entity.getUniqueID().equals(nightmare.getVictimId())) continue;
                doNothing = true;
                break;
            }
            if (!doNothing) {
                Infusion.spawnCreature(world, EntityNightmare.class, entity.getPosition(), entity, 2, 6, null, null);
            }
        }
    }
}

