/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionVolatility
extends WitcheryPotion
implements IHandleLivingHurt {
    public PotionVolatility(int color2) {
        super(true, color2);
        this.setIncurable();
    }

    @Override
    public boolean handleAllHurtEvents() {
        return false;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.isRemote && this.canExplode(event.getSource())) {
            boolean breakable = WitcheryConfigOptions.allowVolatilityPotionBlockDamage;
            if (breakable) {
                breakable = WitcheryUtils.isBlockBreakable(world, entity.getPosition());
            }
            if (event.getSource().isExplosion() || world.rand.nextInt(5 - Math.min(amplifier, 3)) == 0) {
                if (world.rand.nextInt(amplifier + 3) == 0) {
                    entity.removePotionEffect((Potion)this);
                }
                world.createExplosion((Entity)(event.getSource().isExplosion() ? entity : null), entity.posX, entity.posY, entity.posZ, Math.min(2.0f + 0.5f * (float)amplifier, 3.0f), breakable);
            }
        }
    }

    private boolean canExplode(DamageSource source) {
        return source != DamageSource.DROWN && source != DamageSource.IN_WALL && source != DamageSource.FALL && source != DamageSource.OUT_OF_WORLD && source != DamageSource.STARVE;
    }
}

