/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.KeyBindHelper;

public class PotionSwimming
extends WitcheryPotion
implements IHandleLivingUpdate {
    public PotionSwimming(int color2) {
        super(color2);
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (world.isRemote && player.isInWater() && !player.isPotionActive(WitcheryPotionEffects.PARALYSED) && KeyBindHelper.isKeyBindDown(Minecraft.getMinecraft().gameSettings.keyBindForward)) {
                amplifier = 3;
                player.motionX *= 1.15 + 0.03 * (double)amplifier;
                player.motionZ *= 1.15 + 0.03 * (double)amplifier;
            }
        } else if (world.isRemote && world.getTotalWorldTime() % 10L == 3L && entity.isInWater() && entity.isPotionActive(WitcheryPotionEffects.PARALYSED)) {
            entity.motionX *= 1.15 + 0.03 * (double)amplifier;
            entity.motionZ *= 1.15 + 0.03 * (double)amplifier;
        }
    }
}

