/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionSunAllergy
extends WitcheryPotion
implements IHandleLivingUpdate {
    public PotionSunAllergy(int color2) {
        super(true, color2);
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        float f;
        if (!world.isRemote && world.getWorldTime() % 20L == 0L && world.isDaytime() && (f = entity.getBrightness()) > 0.5f && !entity.isInWater() && world.rand.nextFloat() < f - 0.45f && world.canSeeSky(entity.getPosition())) {
            boolean burnEntity = true;
            ItemStack itemstack = entity.getItemStackFromSlot(EntityEquipmentSlot.HEAD);
            if (!itemstack.isEmpty() && !(entity instanceof EntityPlayer)) {
                if (itemstack.isItemStackDamageable()) {
                    itemstack.setItemDamage(itemstack.getItemDamage() + world.rand.nextInt(2));
                    if (itemstack.getItemDamage() >= itemstack.getMaxDamage()) {
                        entity.renderBrokenItemStack(itemstack);
                        entity.setItemStackToSlot(EntityEquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
                burnEntity = false;
            }
            if (burnEntity) {
                if (entity instanceof EntityPlayer) {
                    entity.attackEntityFrom(DamageSource.OUT_OF_WORLD, amplifier >= 3 ? 2.0f : 1.0f);
                } else {
                    entity.setFire(8);
                }
            }
        }
    }
}

