/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.client.renderer.ModelOverlayRenderer;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.IHandleRenderLiving;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionSpiked
extends WitcheryPotion
implements IHandleLivingUpdate,
IHandleRenderLiving {
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation TEXTURE;

    public PotionSpiked(int color2) {
        super(color2);
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 5L == 3L) {
            List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, entity.getEntityBoundingBox().expand(0.2 + 0.1 * (double)amplifier, 0.0, 0.2 + 0.1 * (double)amplifier));
            for (EntityLivingBase otherEntity : entities) {
                if (otherEntity == entity) continue;
                otherEntity.attackEntityFrom(DamageSource.CACTUS, (float)(1 + amplifier));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Post<EntityLivingBase> event) {
        if (TEXTURE == null) {
            TEXTURE = new ResourceLocation("witchery", "textures/entities/cactus_overlay.png");
        }
        GlStateManager.pushMatrix();
        Minecraft.getMinecraft().getTextureManager().bindTexture(TEXTURE);
        ModelOverlayRenderer.render(entity, event.getX(), event.getY(), event.getZ(), (RenderLivingBase<EntityLivingBase>)event.getRenderer());
        GlStateManager.popMatrix();
    }
}

