/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionSnowTrail
extends WitcheryPotion {
    public PotionSnowTrail(int color2) {
        super(color2);
    }

    public static void createSnowCovering(World world, BlockPos pos, int radius, EntityPlayer source) {
        if (WitcheryUtils.isBlockBreakable(world, pos)) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    int maxSearch = 8;
                    if (world.isAirBlock(pos)) {
                        for (BlockPos dy : BlockPos.getAllInBox((BlockPos)pos, (BlockPos)pos.down(maxSearch - 1))) {
                            IBlockState block = world.getBlockState(dy);
                            if (block.getMaterial() == Material.AIR) continue;
                            this.setBlockToSnow(world, dy.up(), block);
                            break;
                        }
                    } else {
                        for (BlockPos dy : BlockPos.getAllInBox((BlockPos)pos, (BlockPos)pos.up(maxSearch - 1))) {
                            IBlockState block = world.getBlockState(dy);
                            if (block.getMaterial() != Material.AIR) continue;
                            IBlockState blockBelow = world.getBlockState(dy.down());
                            this.setBlockToSnow(world, dy, blockBelow);
                            break;
                        }
                    }
                }

                private void setBlockToSnow(World world, BlockPos pos, IBlockState blockBelow) {
                    if (blockBelow.isOpaqueCube() || blockBelow.getMaterial() == Material.LEAVES) {
                        world.setBlockState(pos, Blocks.SNOW_LAYER.getDefaultState());
                    }
                }
            }.processFilledCircle(world, pos, radius);
        }
    }

    public boolean isReady(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        if (!entity.world.isRemote) {
            for (int l = 0; l < 4; ++l) {
                float temp;
                int k;
                int j;
                int i = MathHelper.floor((double)(entity.posX + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos pos = new BlockPos(i, j = MathHelper.floor((double)entity.posY), k = MathHelper.floor((double)(entity.posZ + (double)(((float)l / 2.0f % 2.0f * 2.0f - 1.0f) * 0.25f))));
                if (entity.world.getBlockState(pos).getMaterial() != Material.AIR || !((temp = entity.world.getBiomeForCoordsBody(pos).getTemperature(pos)) < 1.6f) || !Blocks.SNOW_LAYER.canPlaceBlockAt(entity.world, pos)) continue;
                entity.world.setBlockState(pos, Blocks.SNOW_LAYER.getDefaultState());
            }
            if (entity instanceof EntitySnowman && entity.world.rand.nextInt(20) == 0) {
                entity.world.createExplosion((Entity)entity, entity.posX, entity.posY, entity.posZ, 3.0f, false);
                PotionSnowTrail.createSnowCovering(entity.world, entity.getPosition(), 8, null);
                entity.setDead();
            }
        }
    }
}

