/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionSinking
extends WitcheryPotion
implements IHandleLivingUpdate {
    public PotionSinking(int color2) {
        super(true, color2);
        this.setPermanent();
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (world.isRemote) {
                if (player.isInWater()) {
                    if (player.motionY < -0.03 && !player.onGround) {
                        player.motionY *= 1.5 + Math.min(0.05 * (double)amplifier, 0.2);
                    } else if (!player.onGround) {
                        player.isInsideOfMaterial(Material.WATER);
                    }
                } else if (!player.capabilities.isCreativeMode && player.capabilities.allowFlying && player.capabilities.isFlying) {
                    player.motionY = -0.2f;
                }
            }
        } else if (world.isRemote && world.getTotalWorldTime() % 20L == 3L && entity.isInWater()) {
            if (entity.motionY < 0.0) {
                entity.motionY *= 1.0 + Math.min(0.1 * (double)(amplifier + 2), 0.4);
            } else if (entity.motionY > 0.0) {
                entity.motionY *= 1.0 - Math.min(0.1 * (double)(amplifier + 2), 0.4);
            }
        }
    }
}

