/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.network.PacketSyncEntitySize;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.IHandleLivingJump;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.IHandlePreRenderLiving;
import net.msrandom.witchery.potion.IHandleRenderLiving;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.EntitySizeInfo;
import net.msrandom.witchery.util.ResizingUtils;

public class PotionResizing
extends WitcheryPotion
implements IHandlePreRenderLiving,
IHandleRenderLiving,
IHandleLivingUpdate,
IHandleLivingHurt,
IHandleLivingJump {
    public PotionResizing(int color2) {
        super(color2);
    }

    public static float getModifiedScaleFactor(EntityLivingBase entity, int amplifier) {
        float currentHeight = entity.height;
        EntitySizeInfo sizeInfo = new EntitySizeInfo(entity);
        float ratio = currentHeight / PotionResizing.getDefaultHeight(sizeInfo, amplifier);
        float factor = PotionResizing.getTargetHeight(sizeInfo, amplifier);
        return factor < 1.0f ? Math.max(ratio, factor) : Math.min(ratio, factor);
    }

    public static float getScaleFactor(int amplifier) {
        amplifier = MathHelper.abs((int)amplifier);
        return MathHelper.sin((float)((float)amplifier * 0.7f - 3.0f)) + (float)amplifier + (float)MathHelper.floor((float)MathHelper.clamp((int)(amplifier - 1), (int)0, (int)1)) * 0.5f + 0.38f;
    }

    private static float getDefaultHeight(EntitySizeInfo sizeInfo, int amplifier) {
        return amplifier < 0 ? PotionResizing.getScaleFactor(amplifier) * 2.0f : sizeInfo.defaultHeight;
    }

    private static float getTargetHeight(EntitySizeInfo sizeInfo, int amplifier) {
        return amplifier < 0 ? 1.0f : PotionResizing.getScaleFactor(amplifier);
    }

    private static int getSize(PotionEffect amplifier) {
        if (amplifier == null) {
            return 3;
        }
        switch (amplifier.getAmplifier()) {
            default: {
                return 3;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: 
        }
        return 5;
    }

    public static float getDamageMultiplier(PotionEffect amplifierA, PotionEffect amplifierB) {
        int sizeA = PotionResizing.getSize(amplifierA);
        int sizeB = PotionResizing.getSize(amplifierB);
        return sizeA / sizeB;
    }

    @Override
    public void removeAttributesModifiersFromEntity(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        EntitySizeInfo sizeInfo = new EntitySizeInfo(entity);
        ResizingUtils.setSize((Entity)entity, sizeInfo.defaultWidth, sizeInfo.defaultHeight);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.eyeHeight = sizeInfo.eyeHeight;
        }
        entity.stepHeight = sizeInfo.stepSize;
        WitcheryNetworkChannel.sendToAll(new PacketSyncEntitySize((Entity)entity));
        super.removeAttributesModifiersFromEntity(entity, attributes, amplifier);
    }

    @Override
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Pre<EntityLivingBase> event, int amplifier) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)event.getX(), (double)event.getY(), (double)event.getZ());
        float scale = PotionResizing.getModifiedScaleFactor(entity, amplifier);
        GlStateManager.scale((float)scale, (float)scale, (float)scale);
        GlStateManager.translate((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
    }

    @Override
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Post<EntityLivingBase> event) {
        GlStateManager.popMatrix();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        float reductionFactor = 0.03f * (float)(event.getEntity().world.isRemote ? 1 : 20);
        if (world.isRemote || entity.ticksExisted % 20 == 0) {
            EntitySizeInfo sizeInfo = new EntitySizeInfo(entity);
            float scale = PotionResizing.getScaleFactor(amplifier);
            float requiredHeight = sizeInfo.defaultHeight * scale;
            float requiredWidth = sizeInfo.defaultWidth * scale;
            float currentHeight = event.getEntityLiving().height;
            if (requiredHeight != currentHeight) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (!world.isRemote) {
                        player.eyeHeight = currentHeight * 0.92f;
                    }
                }
                float f = entity.stepHeight = scale < 1.0f ? 0.0f : scale - 1.0f;
                if (scale < 1.0f) {
                    ResizingUtils.setSize((Entity)entity, Math.max(entity.width - reductionFactor, requiredWidth), Math.max(currentHeight - reductionFactor, requiredHeight));
                } else {
                    ResizingUtils.setSize((Entity)entity, Math.min(entity.width + reductionFactor, requiredWidth), Math.min(currentHeight + reductionFactor, requiredHeight));
                }
            }
        }
    }

    @Override
    public boolean handleAllHurtEvents() {
        return true;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.isRemote) {
            PotionEffect effectDefender = entity.getActivePotionEffect((Potion)this);
            boolean isDefenderShrunken = effectDefender != null;
            DamageSource source = event.getSource();
            if (source.getDamageType().equals("mob") || source.getDamageType().equals("player")) {
                if (source.getTrueSource() != null && source.getTrueSource() instanceof EntityLivingBase) {
                    EntityLivingBase attacker = (EntityLivingBase)source.getTrueSource();
                    PotionEffect effectAttacker = attacker.getActivePotionEffect((Potion)this);
                    if (isDefenderShrunken || effectAttacker != null) {
                        float scale = PotionResizing.getDamageMultiplier(effectAttacker, effectDefender);
                        event.setAmount(event.getAmount() * Math.max(Math.min(scale, 3.0f), 0.5f));
                    }
                }
            } else if (source == DamageSource.FALL && isDefenderShrunken && PotionResizing.getScaleFactor(effectDefender.getAmplifier()) > event.getAmount()) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public void onLivingJump(LivingEvent.LivingJumpEvent event, int amplifier) {
        float scale = PotionResizing.getScaleFactor(amplifier);
        if (scale > 1.0f) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            entityLiving.motionY *= (double)scale * 0.5 + 0.5;
        } else {
            EntityLivingBase entityLiving2 = event.getEntityLiving();
            entityLiving2.motionY *= Math.max((double)scale, 0.5) * 1.5;
        }
    }
}

