/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionReflectProjectiles
extends WitcheryPotion {
    public PotionReflectProjectiles(int color2) {
        super(color2);
    }

    public boolean isReady(int duration, int amplifier) {
        return true;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        World world = entity.world;
        double RADIUS = 2.0;
        double RADIUS_SQ = 4.0;
        AxisAlignedBB bounds = entity.getEntityBoundingBox().expand(RADIUS, RADIUS, RADIUS);
        List projectileList = world.getEntitiesWithinAABB(Entity.class, bounds);
        for (Entity projectile : projectileList) {
            EntityThrowable arrow2;
            if (!(projectile instanceof IProjectile)) continue;
            if (projectile instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)projectile;
                if (arrow.shootingEntity == entity) {
                    continue;
                }
            } else if (projectile instanceof EntityThrowable && (arrow2 = (EntityThrowable)projectile).getThrower() == entity) continue;
            projectile.motionX *= -0.25 * (1.0 + (double)amplifier);
            if (projectile.motionX > 0.0 || projectile.motionZ > 0.0) {
                projectile.motionY *= -0.25 * (1.0 + (double)amplifier);
            }
            projectile.motionZ *= -0.25 * (1.0 + (double)amplifier);
        }
    }
}

