/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionPoisonWeapons
extends WitcheryPotion
implements IHandleLivingHurt {
    public PotionPoisonWeapons(int color2) {
        super(color2);
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        EntityLivingBase attacker;
        PotionEffect poisonedAttack;
        if (!world.isRemote && event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityLivingBase && this.isValidDamageType(event.getSource().getDamageType()) && (poisonedAttack = (attacker = (EntityLivingBase)event.getSource().getTrueSource()).getActivePotionEffect((Potion)this)) != null) {
            switch (poisonedAttack.getAmplifier()) {
                case 0: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.POISON, 100, 0));
                    break;
                }
                case 1: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.POISON, 100, 1));
                    break;
                }
                case 2: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.POISON, 300, 1));
                    break;
                }
                default: {
                    entity.addPotionEffect(new PotionEffect(MobEffects.WITHER, 400, 0));
                }
            }
        }
    }

    private boolean isValidDamageType(String damageType) {
        return damageType.equals("mob") || damageType.equals("player");
    }

    @Override
    public boolean handleAllHurtEvents() {
        return true;
    }
}

