/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.msrandom.witchery.entity.ai.EntityAIVillagerMateNow;
import net.msrandom.witchery.entity.ai.EntityAIZombieMateNow;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionLove
extends WitcheryPotion
implements IHandleLivingUpdate {
    public PotionLove(int color2) {
        super(color2);
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 20L == 7L) {
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.getGrowingAge() >= 0 && !animal.isInLove()) {
                    animal.setGrowingAge(0);
                    animal.setInLove(null);
                }
            } else if (entity instanceof EntityZombie) {
                EntityZombie zombie = (EntityZombie)entity;
                if (!zombie.isChild()) {
                    for (EntityAITasks.EntityAITaskEntry task : zombie.tasks.taskEntries) {
                        if (!(task.action instanceof EntityAIZombieMateNow)) continue;
                        ((EntityAIZombieMateNow)task.action).beginMating();
                        return;
                    }
                    EntityAIZombieMateNow ai = new EntityAIZombieMateNow(zombie);
                    ai.beginMating();
                    zombie.tasks.addTask(1, (EntityAIBase)ai);
                }
            } else if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                if (!villager.isChild() && !villager.isMating()) {
                    for (EntityAITasks.EntityAITaskEntry task : villager.tasks.taskEntries) {
                        if (!(task.action instanceof EntityAIVillagerMateNow)) continue;
                        ((EntityAIVillagerMateNow)task.action).beginMating();
                        return;
                    }
                    EntityAIVillagerMateNow ai2 = new EntityAIVillagerMateNow(villager);
                    ai2.beginMating();
                    villager.tasks.addTask(1, (EntityAIBase)ai2);
                }
            } else if (entity instanceof EntityPlayer && world.rand.nextBoolean()) {
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(event.getEntityLiving().posX, event.getEntityLiving().posY + 1.0, event.getEntityLiving().posZ, 0.6f, 2.0f, EnumParticleTypes.HEART), world, event.getEntityLiving().posX, event.getEntityLiving().posY + 1.0, event.getEntityLiving().posZ);
            }
        }
    }
}

