/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityIllusionCreeper;
import net.msrandom.witchery.entity.EntityIllusionSpider;
import net.msrandom.witchery.entity.EntityIllusionZombie;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionInsanity
extends WitcheryPotion {
    public PotionInsanity(int color2) {
        super(true, color2);
        this.setIncurable();
        this.setPermanent();
        this.hideInventoryText();
        this.hideUnknownText = true;
    }

    public boolean isReady(int duration, int amplifier) {
        return duration % 20 == 13;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            World world = entity.world;
            int level = Math.max(0, amplifier) + 1;
            if (world.rand.nextInt(level > 2 ? 25 : (level > 1 ? 30 : 35)) == 0) {
                Class creatureType;
                switch (world.rand.nextInt(3)) {
                    default: {
                        creatureType = EntityIllusionCreeper.class;
                        break;
                    }
                    case 1: {
                        creatureType = EntityIllusionSpider.class;
                        break;
                    }
                    case 2: {
                        creatureType = EntityIllusionZombie.class;
                    }
                }
                int MAX_DISTANCE = 9;
                int MIN_DISTANCE = 4;
                Infusion.spawnCreature(world, creatureType, entity.getPosition(), player, MIN_DISTANCE, MAX_DISTANCE);
            } else if (level >= 4 && world.rand.nextInt(20) == 0) {
                SoundEvent sound = world.rand.nextInt(3) == 1 ? SoundEvents.ENTITY_ENDERMEN_AMBIENT : SoundEvents.ENTITY_GENERIC_EXPLODE;
                WitcheryUtils.playSoundAt((EntityPlayer)entity, sound, entity.getSoundCategory(), 1.0f, 1.0f);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        super.renderInventoryEffect(effect, gui, x, y, z);
        FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
        int factor = effect.getDuration() / 60 % 7;
        fontRenderer.drawStringWithShadow(I18n.format((String)(this.getName() + "." + factor), (Object[])new Object[0]), (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
        fontRenderer.drawStringWithShadow(PotionInsanity.getPotionDurationString((PotionEffect)effect, (float)1.0f), (float)(x + 28), (float)(y + 16), 0x7F7F7F);
    }
}

