/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.ReflectiveEntity;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionIllFitting
extends WitcheryPotion {
    public static final EntityEquipmentSlot[] SLOTS = EntityEquipmentSlot.values();

    public PotionIllFitting(int color2) {
        super(true, color2);
        this.setPermanent();
        this.setIncurable();
    }

    public static boolean isTargetAllowed(EntityLivingBase entity) {
        return !(entity instanceof ReflectiveEntity);
    }

    public boolean isReady(int duration, int amplifier) {
        if (duration % 15 != 0) {
            return false;
        }
        switch (amplifier) {
            case 3: {
                return duration <= 60;
            }
            case 2: {
                return duration <= 45;
            }
            case 1: {
                return duration <= 30;
            }
        }
        return duration <= 15;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        EntityEquipmentSlot slot;
        ItemStack armorPiece;
        World world = entity.world;
        if (!world.isRemote && PotionIllFitting.isTargetAllowed(entity) && !(armorPiece = entity.getItemStackFromSlot(slot = SLOTS[world.rand.nextInt(4) + 2])).isEmpty()) {
            entity.setItemStackToSlot(slot, ItemStack.EMPTY);
            entity.entityDropItem(armorPiece, 0.0f).setPickupDelay(5 + 5 * amplifier);
        }
    }
}

