/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.IHandleRenderLiving;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionHellishAura
extends WitcheryPotion
implements IHandleRenderLiving {
    public PotionHellishAura(int color2) {
        super(color2);
    }

    public boolean isReady(int duration, int amplifier) {
        int frequencyFactor = 25;
        int k = frequencyFactor >> amplifier;
        return k <= 0 || duration % k == 0;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        World world = entity.world;
        if (!world.isRemote) {
            List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, entity.getEntityBoundingBox().expand(1.5, 0.0, 1.5));
            for (EntityLivingBase otherEntity : entities) {
                if (entity == otherEntity) continue;
                otherEntity.attackEntityFrom(new EntityDamageSource(DamageSource.ON_FIRE.damageType, (Entity)entity).setFireDamage().setDamageBypassesArmor(), 1.0f);
                otherEntity.world.playSound(null, otherEntity.getPosition(), SoundEvents.ENTITY_GHAST_SHOOT, entity.getSoundCategory(), 0.5f, 0.4f / (otherEntity.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(otherEntity.posX, otherEntity.posY, otherEntity.posZ, otherEntity.width, otherEntity.height, EnumParticleTypes.FLAME), (Entity)otherEntity);
                if (amplifier <= 0) continue;
                otherEntity.setFire(amplifier);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Post<EntityLivingBase> event) {
        GlStateManager.disableLighting();
        TextureAtlasSprite iicon = Minecraft.getMinecraft().getTextureMapBlocks().getTextureExtry("textures/blocks/fire_layer_0.png");
        TextureAtlasSprite iicon2 = Minecraft.getMinecraft().getTextureMapBlocks().getTextureExtry("textures/blocks/fire_layer_1.png");
        GlStateManager.pushMatrix();
        float f1 = entity.width * 1.4f;
        GlStateManager.scale((float)f1, (float)f1, (float)f1);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        float f2 = 0.5f;
        float f3 = 0.0f;
        float f4 = entity.height / f1;
        float f5 = (float)(entity.posY - entity.getEntityBoundingBox().minY);
        GlStateManager.rotate((float)(-Minecraft.getMinecraft().getRenderManager().playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f4) * 0.02f));
        GlStateManager.color((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        float f6 = 0.0f;
        int i = 0;
        if (iicon != null && iicon2 != null) {
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            while (f4 > 0.0f) {
                TextureAtlasSprite iicon3 = i % 2 == 0 ? iicon : iicon2;
                Minecraft.getMinecraft().getRenderManager().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                float f7 = iicon3.getMinU();
                float f8 = iicon3.getMinV();
                float f9 = iicon3.getMaxU();
                float f10 = iicon3.getMaxV();
                if (i / 2 % 2 == 0) {
                    float f11 = f9;
                    f9 = f7;
                    f7 = f11;
                }
                buffer.pos((double)(f2 - f3), (double)(0.0f - f5), (double)f6).tex((double)f9, (double)f10).endVertex();
                buffer.pos((double)(-f2 - f3), (double)(0.0f - f5), (double)f6).tex((double)f7, (double)f10).endVertex();
                buffer.pos((double)(-f2 - f3), (double)(1.4f - f5), (double)f6).tex((double)f7, (double)f8).endVertex();
                buffer.pos((double)(f2 - f3), (double)(1.4f - f5), (double)f6).tex((double)f9, (double)f8).endVertex();
                f4 -= 0.45f;
                f5 -= 0.45f;
                f2 *= 0.9f;
                f6 += 0.03f;
                ++i;
            }
            tessellator.draw();
        }
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }
}

