/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionFloating
extends WitcheryPotion {
    public PotionFloating(int color2) {
        super(color2);
    }

    public boolean isReady(int duration, int amplifier) {
        return true;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        int height2 = 3 + amplifier;
        int x = MathHelper.floor((double)entity.posX);
        int y = MathHelper.floor((double)entity.posY);
        int z = MathHelper.floor((double)entity.posZ);
        boolean isPlayer = entity instanceof EntityPlayer;
        boolean activeOnSide = isPlayer && entity.world.isRemote || !isPlayer && !entity.world.isRemote;
        entity.fallDistance = 0.0f;
        if (activeOnSide) {
            boolean raised = false;
            for (int i = 1; i <= height2; ++i) {
                if (entity.world.isAirBlock(new BlockPos(x, y - i, z))) continue;
                entity.motionY = 0.25;
                raised = true;
                break;
            }
            if (!raised) {
                entity.motionY = entity.world.rand.nextInt(5) == 0 ? -0.05 : 0.0;
            }
        }
    }
}

