/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.EntityUtil;

public class PotionFeelNoPain
extends WitcheryPotion
implements IHandleLivingHurt,
IHandleLivingUpdate {
    public PotionFeelNoPain(int color2) {
        super(color2);
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!(world.isRemote || world.getWorldTime() % 20L != 2L || amplifier <= 0 || entity.isPotionActive(MobEffects.NAUSEA) || entity.isPotionActive(WitcheryPotionEffects.STOUT_BELLY) || world.rand.nextInt(5 - Math.min(amplifier, 3)) != 0)) {
            entity.addPotionEffect(new PotionEffect(MobEffects.NAUSEA, (6 + amplifier * 2) * 20));
        }
    }

    @Override
    public boolean handleAllHurtEvents() {
        return false;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.isRemote && entity instanceof EntityPlayer && (event.getSource().getDamageType().equals("mob") || event.getSource().getDamageType().equals("player") || event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityLivingBase)) {
            EntityPlayer player = (EntityPlayer)entity;
            float currentHealth = entity.getHealth();
            float newHealth = EntityUtil.getHealthAfterDamage(event, currentHealth, entity);
            float damage = currentHealth - newHealth;
            int food = player.getFoodStats().getFoodLevel();
            if (food > 0) {
                int modifiedDamage = (int)Math.ceil(amplifier > 0 ? (double)Math.max(damage / (float)amplifier, amplifier > 1 ? 1.0f : 2.0f) : (double)Math.max(damage * 2.0f, 3.0f));
                int foodPenalty = Math.min(modifiedDamage, food);
                player.getFoodStats().addStats(-foodPenalty, 2.0f);
                event.setCanceled(true);
            }
        }
    }
}

