/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.msrandom.witchery.entity.EntityEnt;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.ai.EntityAIEnslaverHurtByTarget;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.IHandleLivingSetAttackTarget;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.EntityUtil;

public class PotionEnslaved
extends WitcheryPotion
implements IHandleLivingSetAttackTarget,
IHandleLivingUpdate {
    private static final String ENSLAVER_KEY = "WitcheryEnslaverName";

    public PotionEnslaved(int color2) {
        super(true, color2);
    }

    public static boolean setEnslaverForMob(EntityLiving entity, EntityPlayer player) {
        boolean isEnslaved;
        if (entity == null || player == null) {
            return false;
        }
        String enslaverName = entity.getEntityData().getString(ENSLAVER_KEY);
        boolean bl = isEnslaved = !enslaverName.isEmpty();
        if (!isEnslaved || !player.getName().equals(enslaverName)) {
            entity.getEntityData().setString(ENSLAVER_KEY, player.getName());
            entity.addPotionEffect(new PotionEffect(WitcheryPotionEffects.ENSLAVED, Integer.MAX_VALUE));
            EntityUtil.dropAttackTarget(entity);
            return true;
        }
        return false;
    }

    public static boolean isMobEnslavedBy(EntityLiving entity, EntityPlayer player) {
        if (player == null || entity == null) {
            return false;
        }
        return player.getName().equals(entity.getEntityData().getString(ENSLAVER_KEY));
    }

    public static boolean canCreatureBeEnslaved(EntityLivingBase entityLiving) {
        return entityLiving instanceof EntityLiving && entityLiving.isNonBoss() && !(entityLiving instanceof EntityGolem) && !(entityLiving instanceof EntityWitch) && !(entityLiving instanceof EntityImp) && !(entityLiving instanceof EntityEnt);
    }

    public static boolean isMobEnslaved(EntityLiving entity) {
        if (entity == null) {
            return false;
        }
        String enslaverName = entity.getEntityData().getString(ENSLAVER_KEY);
        return !enslaverName.isEmpty();
    }

    public static UUID getMobEnslaverId(EntityLiving entity) {
        if (entity == null) {
            return null;
        }
        return entity.getEntityData().getUniqueId(ENSLAVER_KEY);
    }

    @Override
    public void onLivingSetAttackTarget(EntityLiving entity, LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getTarget() instanceof EntityPlayer && entity instanceof EntityLiving) {
            UUID enslaver = PotionEnslaved.getMobEnslaverId(entity);
            if (event.getTarget().getUniqueID().equals(enslaver)) {
                entity.setAttackTarget(null);
            }
        }
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 20L == 3L && entity instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)entity;
            for (EntityAITasks.EntityAITaskEntry task : creature.targetTasks.taskEntries) {
                if (!(task.action instanceof EntityAIEnslaverHurtByTarget)) continue;
                return;
            }
            creature.targetTasks.addTask(1, (EntityAIBase)new EntityAIEnslaverHurtByTarget(creature));
        }
    }
}

