/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.client.renderer.ModelOverlayRenderer;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.potion.IHandleRenderLiving;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionDiseased
extends WitcheryPotion
implements IHandleRenderLiving {
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation TEXTURE;

    public PotionDiseased(int color2) {
        super(true, color2);
        this.setIncurable();
    }

    @Override
    public void init() {
        this.registerPotionAttributeModifier(SharedMonsterAttributes.ATTACK_DAMAGE, "22653B89-116E-49DC-9B6B-9971489B5BE5", 2.0, 0);
    }

    public double getAttributeModifierAmount(int amplifier, AttributeModifier p_111183_2_) {
        return -0.5f * (float)(Math.min(amplifier, 1) + 1);
    }

    public boolean isReady(int duration, int amplifier) {
        return duration % 40 == 4;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        BlockPos pos;
        if (!entity.world.isRemote && entity.world.rand.nextInt(3) == 0 && entity.world.isAirBlock(pos = entity.getPosition()) && entity.world.getBlockState(pos.down()).getMaterial().isSolid() && WitcheryUtils.isBlockBreakable(entity.world, pos)) {
            entity.world.setBlockState(pos, WitcheryBlocks.DISEASE.getDefaultState());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Post<EntityLivingBase> event) {
        if (TEXTURE == null) {
            TEXTURE = new ResourceLocation("witchery", "textures/entities/disease_overlay.png");
        }
        GlStateManager.pushMatrix();
        Minecraft.getMinecraft().getTextureManager().bindTexture(TEXTURE);
        ModelOverlayRenderer.render(entity, event.getX(), event.getY(), event.getZ(), (RenderLivingBase<EntityLivingBase>)event.getRenderer());
        GlStateManager.popMatrix();
    }
}

