/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionChilled
extends WitcheryPotion
implements IHandleLivingHurt {
    public PotionChilled(int color2) {
        super(color2);
    }

    @Override
    public void init() {
        this.registerPotionAttributeModifier(SharedMonsterAttributes.MOVEMENT_SPEED, "7A20B8CD-7A97-4800-A7DC-5B464E31A11A", -0.1, 2);
    }

    @Override
    public boolean handleAllHurtEvents() {
        return false;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.isRemote && event.getSource().isFireDamage()) {
            event.setAmount(Math.max(event.getAmount() - (float)(1 + amplifier), Math.min(event.getAmount(), amplifier >= 2 ? 0.0f : 1.0f)));
        }
    }

    public boolean isReady(int duration, int amplifier) {
        int k = 25 >> amplifier;
        return k <= 0 || duration % k == 0;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityBlaze || amplifier >= 2) {
            entity.attackEntityFrom(DamageSource.MAGIC, 1.0f);
        }
    }
}

