/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionAttractProjectiles
extends WitcheryPotion {
    public PotionAttractProjectiles(int color2) {
        super(true, color2);
    }

    public boolean isReady(int duration, int amplifier) {
        return true;
    }

    public void performEffect(EntityLivingBase target, int amplifier) {
        World world = target.world;
        double RADIUS = (1.0 + (double)amplifier) * 3.0;
        double RADIUS_SQ = RADIUS * RADIUS;
        AxisAlignedBB bounds = target.getEntityBoundingBox().expand(RADIUS, RADIUS, RADIUS);
        List projectileList = world.getEntitiesWithinAABB(Entity.class, bounds);
        for (Entity arrow : projectileList) {
            double FAST_SQ;
            double velocitySq;
            if (!(arrow instanceof IProjectile) || arrow.ticksExisted < ((velocitySq = arrow.motionX * arrow.motionX + arrow.motionY * arrow.motionY + arrow.motionZ * arrow.motionZ) > (FAST_SQ = 0.25) ? 1 : 10)) continue;
            double d0 = target.posX - arrow.posX;
            double d2 = target.getEntityBoundingBox().minY + (double)target.height * 0.75 - arrow.posY;
            double d3 = target.posZ - arrow.posZ;
            double d4 = MathHelper.sqrt((double)(d0 * d0 + d3 * d3));
            if (d4 < 1.0E-7) continue;
            ((IProjectile)arrow).shoot(d0, d2, d3, 1.0f, 1.0f);
        }
    }
}

