/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.GameData;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.brew.InfusedBrewEffect;
import net.msrandom.witchery.infusion.creature.CreaturePowerData;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/network/PacketPlayerSync;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "brewEffect", "", "brewTime", "", "creaturePower", "Lnet/msrandom/witchery/infusion/creature/CreaturePowerData;", "infusionPower", "Lnet/msrandom/witchery/common/InfusionPower;", "apply", "", "write", "WitcheryResurrected"})
public final class PacketPlayerSync
implements WitcheryNetworkPacket {
    private final InfusionPower infusionPower;
    private final CreaturePowerData creaturePower;
    private final int brewEffect;
    private final long brewTime;

    @Override
    public void write(@NotNull PacketBuffer buffer) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        buffer.writeVarInt(Infusion.REGISTRY.getId(this.infusionPower.getInfusionType()));
        buffer.writeVarInt(this.infusionPower.getCurrentPower());
        buffer.writeVarInt(this.infusionPower.getMaxPower());
        PacketBuffer packetBuffer = buffer;
        Object object = this.creaturePower;
        if (object != null && (object = ((CreaturePowerData)object).getEntityType()) != null) {
            Object object2 = object;
            PacketBuffer packetBuffer2 = packetBuffer;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            int n2 = EntityList.getID((Class)p1);
            packetBuffer = packetBuffer2;
            n = n2;
        } else {
            n = -1;
        }
        packetBuffer.writeVarInt(n);
        CreaturePowerData creaturePowerData = this.creaturePower;
        buffer.writeVarInt(creaturePowerData != null ? creaturePowerData.getCharges() : 0);
        buffer.writeVarInt(this.brewEffect);
        buffer.writeVarLong(this.brewTime);
    }

    @Override
    public void apply(@NotNull EntityPlayer player) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            WitcheryUtils.getExtension((EntityPlayer)player).infusionPower = this.infusionPower;
            WitcheryUtils.getExtension((EntityPlayer)player).creaturePower = this.creaturePower;
            ResourceLocation resourceLocation = InfusedBrewEffect.REGISTRY.getKey(this.brewEffect);
            if (resourceLocation == null) break block0;
            ResourceLocation resourceLocation2 = resourceLocation;
            boolean bl = false;
            boolean bl2 = false;
            ResourceLocation it = resourceLocation2;
            boolean bl3 = false;
            InfusedBrewEffect.setActiveBrewInfo(player.getEntityData(), it, this.brewTime);
        }
    }

    public PacketPlayerSync(@NotNull EntityPlayer player) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        InfusionPower infusionPower = playerEx.infusionPower;
        Intrinsics.checkExpressionValueIsNotNull((Object)infusionPower, (String)"playerEx.infusionPower");
        this.infusionPower = infusionPower;
        this.creaturePower = playerEx.creaturePower;
        NBTTagCompound playerData = player.getEntityData();
        InfusedBrewEffect brew = InfusedBrewEffect.getActiveBrew(playerData);
        long time = InfusedBrewEffect.getActiveBrewStartTime(playerData);
        this.brewEffect = InfusedBrewEffect.REGISTRY.getId(brew);
        PacketPlayerSync packetPlayerSync = this;
        if (brew == null) {
            l = 0L;
        } else {
            long remainingTicks = 144000L - (MinecraftServer.getCurrentTimeMillis() / 50L - time);
            if (remainingTicks > 0L) {
                double d = (double)remainingTicks / 1200.0;
                PacketPlayerSync packetPlayerSync2 = packetPlayerSync;
                boolean bl = false;
                double d2 = Math.ceil(d);
                packetPlayerSync = packetPlayerSync2;
                l = (long)d2;
            } else {
                l = 0L;
            }
        }
        packetPlayerSync.brewTime = l;
    }

    public PacketPlayerSync(@NotNull PacketBuffer buffer) {
        CreaturePowerData creaturePowerData;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Infusion infusion = Infusion.REGISTRY.get(buffer.readVarInt());
        if (infusion == null) {
            Infusion infusion2 = Infusion.DEFUSED;
            infusion = infusion2;
            Intrinsics.checkExpressionValueIsNotNull((Object)infusion2, (String)"Infusion.DEFUSED");
        }
        this.infusionPower = new InfusionPower(infusion, buffer.readVarInt(), buffer.readVarInt());
        EntityEntry entityEntry = (EntityEntry)GameData.getEntityRegistry().getValue(buffer.readVarInt());
        Class power = entityEntry != null ? entityEntry.getEntityClass() : null;
        int charges = buffer.readVarInt();
        PacketPlayerSync packetPlayerSync = this;
        Class clazz = power;
        if (clazz != null) {
            Class clazz2 = clazz;
            PacketPlayerSync packetPlayerSync2 = packetPlayerSync;
            boolean bl = false;
            boolean bl2 = false;
            Class it = clazz2;
            boolean bl3 = false;
            CreaturePowerData creaturePowerData2 = new CreaturePowerData(it, charges);
            packetPlayerSync = packetPlayerSync2;
            creaturePowerData = creaturePowerData2;
        } else {
            creaturePowerData = null;
        }
        packetPlayerSync.creaturePower = creaturePowerData;
        this.brewEffect = buffer.readVarInt();
        this.brewTime = buffer.readVarLong();
    }
}

