/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/network/PacketPlayerStyle;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "blood", "", "creatureType", "Lnet/msrandom/witchery/transformation/AlternateForm;", "ghost", "", "grotesqueTicks", "nightmareLevel", "Lnet/msrandom/witchery/world/dimension/spirit/SpiritWorldData$NightmareLevel;", "playerId", "playerSkin", "", "apply", "", "write", "WitcheryResurrected"})
public final class PacketPlayerStyle
implements WitcheryNetworkPacket {
    private final int playerId;
    private final int grotesqueTicks;
    private final SpiritWorldData.NightmareLevel nightmareLevel;
    private final boolean ghost;
    private final AlternateForm creatureType;
    private final int blood;
    private final String playerSkin;

    @Override
    public void write(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        buffer.writeVarInt(this.playerId);
        buffer.writeVarInt(this.grotesqueTicks);
        buffer.writeEnumValue((Enum)this.nightmareLevel);
        buffer.writeBoolean(this.ghost);
        buffer.writeVarInt(AlternateForm.REGISTRY.getId(this.creatureType));
        buffer.writeVarInt(this.blood);
        String string = this.playerSkin;
        if (string == null) {
            string = "";
        }
        buffer.writeString(string);
    }

    @Override
    public void apply(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Entity otherPlayer = player.world.getEntityByID(this.playerId);
        if (otherPlayer instanceof EntityPlayer) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)otherPlayer);
            playerEx.grotesqueTicks = this.grotesqueTicks;
            playerEx.getSpiritData().setNightmareLevel(this.nightmareLevel);
            playerEx.getSpiritData().setGhost(this.ghost);
            playerEx.setCurrentForm(this.creatureType);
            playerEx.setHumanBlood(this.blood);
            playerEx.setOtherPlayerSkin(this.playerSkin);
        }
    }

    public PacketPlayerStyle(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        this.playerId = player.getEntityId();
        this.grotesqueTicks = playerEx.grotesqueTicks;
        this.nightmareLevel = playerEx.getSpiritData().getNightmareLevel();
        this.ghost = playerEx.getSpiritData().isGhost();
        this.creatureType = playerEx.getCurrentForm();
        this.blood = playerEx.getHumanBlood();
        this.playerSkin = playerEx.getOtherPlayerSkin();
    }

    public PacketPlayerStyle(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.playerId = buffer.readVarInt();
        this.grotesqueTicks = buffer.readVarInt();
        Enum enum_ = buffer.readEnumValue(SpiritWorldData.NightmareLevel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"buffer.readEnumValue(Spi\u2026ghtmareLevel::class.java)");
        this.nightmareLevel = (SpiritWorldData.NightmareLevel)enum_;
        this.ghost = buffer.readBoolean();
        this.creatureType = AlternateForm.REGISTRY.get(buffer.readVarInt());
        this.blood = buffer.readVarInt();
        this.playerSkin = buffer.readString(255);
    }
}

