/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.WerewolfTransformation;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lnet/msrandom/witchery/network/PacketHowl;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "()V", "apply", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "WitcheryResurrected"})
public final class PacketHowl
implements WitcheryNetworkPacket {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void apply(@NotNull EntityPlayer player) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        WerewolfTransformation transformation = playerEx.getTransformation(WitcheryTransformations.WEREWOLF);
        if (transformation.getLevel() == 6 && (object = playerEx.getCurrentForm()) != null && (object = AlternateFormStatManager.INSTANCE.getStats((AlternateForm)object)) != null && ((AlternateForm.Stats)object).canHowl() && transformation.getQuestState() == WerewolfTransformation.QuestState.STARTED) {
            World world = player.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
            if (!world.isDaytime()) {
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
                if (transformation.getVisitedChunks().add(new ChunkPos(MathHelper.floor((double)player.posX) >> 4, MathHelper.floor((double)player.posZ) >> 4))) {
                    WerewolfTransformation werewolfTransformation = transformation;
                    werewolfTransformation.setQuestCount(werewolfTransformation.getQuestCount() + 1);
                    werewolfTransformation.getQuestCount();
                    return;
                }
                player.sendMessage(new TextComponentTranslation("witchery.werewolf.already_visited_chunk", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                return;
            }
        }
        if (Intrinsics.areEqual((Object)playerEx.getCurrentForm(), (Object)WitcheryAlternateForms.WOLF) && transformation.getLevel() >= 8) {
            long lastHowl = transformation.getLastHowl();
            long serverTime = MinecraftServer.getCurrentTimeMillis();
            if (!player.capabilities.isCreativeMode && lastHowl + (long)60000 >= serverTime) {
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
                return;
            }
            WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
            transformation.setLastHowl(serverTime);
            int n = 0;
            int n2 = 2 + player.world.rand.nextInt(transformation.getLevel() - 7);
            while (n < n2) {
                void i;
                EntityCreature creature = Infusion.spawnCreature(player.world, EntityWolf.class, player.getPosition(), player.getLastAttackedEntity(), 1, 6, EnumParticleTypes.SMOKE_NORMAL, null);
                if (creature != null) {
                    creature.addPotionEffect(new PotionEffect(WitcheryPotionEffects.MORTAL_COIL, 200));
                    EntityWolf wolf = (EntityWolf)creature;
                    wolf.setTamed(true);
                    wolf.setOwnerId(player.getUniqueID());
                    wolf.experienceValue = 0;
                    WitcheryUtils.setNoDrops((EntityLivingBase)wolf, true);
                }
                ++i;
            }
            return;
        }
        if (!Intrinsics.areEqual((Object)playerEx.getCurrentForm(), (Object)WitcheryAlternateForms.WOLFMAN)) return;
        if (transformation.getLevel() < 7) return;
        long lastHowl = transformation.getLastHowl();
        long serverTime = MinecraftServer.getCurrentTimeMillis();
        if (!player.capabilities.isCreativeMode && lastHowl + (long)60000 >= serverTime) {
            SoundEvent soundEvent = SoundEvents.BLOCK_NOTE_SNARE;
            Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.BLOCK_NOTE_SNARE");
            WitcheryUtils.playSoundAt(player, soundEvent, 1.0f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
            return;
        }
        WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
        transformation.setLastHowl(serverTime);
        double radius = 16.0;
        List entities = player.world.getEntitiesWithinAABB(EntityLivingBase.class, player.getEntityBoundingBox().expand(radius, radius, radius));
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            EntityLivingBase entity = (EntityLivingBase)iterator.next();
            if (CreatureUtil.isWerewolf((Entity)entity, true) || CreatureUtil.isVampire((Entity)entity)) continue;
            entity.addPotionEffect(new PotionEffect(WitcheryPotionEffects.PARALYSED, (4 + player.world.rand.nextInt(transformation.getLevel() - 6)) * 20, 3));
        }
    }

    public PacketHowl() {
    }

    public PacketHowl(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this();
    }
}

