/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.ingredients;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockPlacedItem;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.EntitySpirit;
import net.msrandom.witchery.entity.EntityTreefyd;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.item.ingredients.IngredientItem;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.WorldProviderSpiritWorld;

public class WitcheryIngredientItem
extends Item {
    public WitcheryIngredientItem() {
        this.setMaxDamage(0);
        this.setMaxStackSize(64);
    }

    public static int getWaystoneDimension(ItemStack stack) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag != null && tag.hasKey("X") && tag.hasKey("Y") && tag.hasKey("Z") && tag.hasKey("Dimension")) {
            return tag.getInteger("Dimension");
        }
        return 0;
    }

    public static boolean teleportToLocationSafely(double posX, double posY, double posZ, int dimension, Entity entity, boolean presetPosition) {
        WorldServer targetWorld = entity.getServer().getWorld(dimension);
        int x = MathHelper.floor((double)posX);
        int y = MathHelper.floor((double)posY);
        int z = MathHelper.floor((double)posZ);
        for (int i = 0; i < 16; ++i) {
            int dy = y + i;
            if (dy < 250 && !BlockUtil.isReplaceableBlock((World)targetWorld, x, dy, z) && BlockUtil.isReplaceableBlock((World)targetWorld, x, dy + 1, z) && BlockUtil.isReplaceableBlock((World)targetWorld, x, dy + 2, z)) {
                WitcheryIngredientItem.teleportToLocation(x, (double)(dy + 1), z, dimension, entity, presetPosition);
                return true;
            }
            dy = y - i;
            if (i <= 0 || dy <= 1 || BlockUtil.isReplaceableBlock((World)targetWorld, x, dy, z) || !BlockUtil.isReplaceableBlock((World)targetWorld, x, dy + 1, z) || !BlockUtil.isReplaceableBlock((World)targetWorld, x, dy + 2, z)) continue;
            WitcheryIngredientItem.teleportToLocation(x, (double)(dy + 1), z, dimension, entity, presetPosition);
            return true;
        }
        return false;
    }

    public static void teleportToLocation(double posX, double posY, double posZ, int dimension, Entity entity, boolean presetPosition) {
        WitcheryIngredientItem.teleportToLocation(new BlockPos(posX, posY, posZ), dimension, entity, presetPosition);
    }

    public static void teleportToLocation(BlockPos pos, int dimension, Entity entity, boolean presetPosition) {
        WitcheryIngredientItem.teleportToLocation(pos, dimension, entity, presetPosition, EnumParticleTypes.PORTAL, SoundEvents.ENTITY_ENDERMEN_TELEPORT);
    }

    public static void teleportToLocation(double posX, double posY, double posZ, int dimension, Entity entity, boolean presetPosition, EnumParticleTypes particle, SoundEvent sound) {
        WitcheryIngredientItem.teleportToLocation(new BlockPos(posX, posY, posZ), dimension, entity, presetPosition, particle, sound);
    }

    public static void teleportToLocation(BlockPos pos, int dimension, Entity entity, boolean presetPosition, EnumParticleTypes particle, SoundEvent sound) {
        boolean isVampire = CreatureUtil.isVampire(entity);
        if (isVampire) {
            entity.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), entity);
        } else {
            if (sound != null) {
                entity.playSound(sound, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            }
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, particle), entity);
        }
        double posX = (double)pos.getX() + 0.5;
        double posY = pos.getY();
        double posZ = (double)pos.getZ() + 0.5;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (entity.dimension != dimension) {
                if (presetPosition) {
                    player.setPosition(posX, posY, posZ);
                }
                WitcheryIngredientItem.travelToDimension(player, dimension);
            }
            player.setPositionAndUpdate(posX, posY, posZ);
        } else if (entity instanceof EntityLiving) {
            if (entity.dimension != dimension) {
                WitcheryIngredientItem.travelToDimension(entity, dimension, pos);
            } else {
                entity.setLocationAndAngles(posX, posY, posZ, entity.rotationYaw, entity.rotationPitch);
            }
        } else if (entity.dimension != dimension) {
            WitcheryIngredientItem.travelToDimension(entity, dimension, pos);
        } else {
            entity.setLocationAndAngles(posX, posY, posZ, entity.rotationYaw, entity.rotationPitch);
        }
        if (isVampire) {
            entity.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), entity);
        } else {
            if (sound != null) {
                entity.playSound(sound, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            }
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, particle), entity);
        }
    }

    public static void travelToDimension(EntityPlayer player, int dimension) {
        player.changeDimension(dimension, (ITeleporter)new WitcheryTeleporter());
    }

    private static void travelToDimension(Entity thisE, int par1, BlockPos pos) {
        thisE.changeDimension(par1, (ITeleporter)new WitcheryTeleporter(pos));
    }

    public static boolean isBrew(ItemStack stack) {
        return stack.getItem() instanceof ItemKettleBrew && ((ItemKettleBrew)stack.getItem()).isPotion();
    }

    public static void bindToLocation(BlockPos pos, int dimension, ItemStack itemstack) {
        if (!itemstack.hasTagCompound()) {
            itemstack.setTagCompound(new NBTTagCompound());
        }
        itemstack.getTagCompound().setInteger("X", pos.getX());
        itemstack.getTagCompound().setInteger("Y", pos.getY());
        itemstack.getTagCompound().setInteger("Z", pos.getZ());
        itemstack.getTagCompound().setInteger("Dimension", dimension);
    }

    public static boolean hasLocationBinding(ItemStack itemstack) {
        if (itemstack.hasTagCompound()) {
            NBTTagCompound nbtTag = itemstack.getTagCompound();
            return nbtTag.hasKey("X") && nbtTag.hasKey("Y") && nbtTag.hasKey("Z") && nbtTag.hasKey("Dimension");
        }
        return false;
    }

    public static void copyLocationBinding(ItemStack from, ItemStack to) {
        if (WitcheryIngredientItem.hasLocationBinding(from)) {
            NBTTagCompound nbtTagFrom = from.getTagCompound();
            if (!to.hasTagCompound()) {
                to.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtTagTo = to.getTagCompound();
            nbtTagTo.setInteger("X", nbtTagFrom.getInteger("X"));
            nbtTagTo.setInteger("Y", nbtTagFrom.getInteger("Y"));
            nbtTagTo.setInteger("Z", nbtTagFrom.getInteger("Z"));
            nbtTagTo.setInteger("Dimension", nbtTagFrom.getInteger("Dimension"));
            if (from.hasDisplayName()) {
                to.setStackDisplayName(from.getDisplayName());
            }
        }
    }

    public static boolean tryCopyLocation(World world, ItemStack from, TileEntityCircle.ActivatedRitual to) {
        if (!WitcheryIngredientItem.hasLocationBinding(from)) {
            return false;
        }
        NBTTagCompound nbtTagFrom = from.getTagCompound();
        if (nbtTagFrom.getInteger("Dimension") != world.provider.getDimension()) {
            return false;
        }
        BlockPos coord = new BlockPos(nbtTagFrom.getInteger("X"), nbtTagFrom.getInteger("Y"), nbtTagFrom.getInteger("Z"));
        to.setLocation(coord);
        return true;
    }

    private static boolean isRestrictedTeleportTarget(int source, int target) {
        int dream = WitcheryDimensions.SPIRIT_WORLD.getType().getId();
        int mirror = WitcheryDimensions.MIRROR.getType().getId();
        return source == target || source != dream && source != mirror && target != dream && target != mirror;
    }

    public static boolean teleportToLocation(World world, ItemStack itemstack, Entity entity, int radius, boolean presetPosition) {
        NBTTagCompound tag = itemstack.getTagCompound();
        if (tag != null && tag.hasKey("X") && tag.hasKey("Y") && tag.hasKey("Z") && tag.hasKey("Dimension")) {
            int newX = tag.getInteger("X") - radius + world.rand.nextInt(radius * 2 + 1);
            int newY = tag.getInteger("Y");
            int newZ = tag.getInteger("Z") - radius + world.rand.nextInt(radius * 2 + 1);
            int newD = tag.getInteger("Dimension");
            if (WitcheryIngredientItem.isRestrictedTeleportTarget(entity.dimension, newD)) {
                WitcheryIngredientItem.teleportToLocation(newX, (double)newY, newZ, newD, entity, presetPosition);
                return true;
            }
        } else if (tag != null) {
            EntityLivingBase target = ItemTaglockKit.getBoundEntity(world, itemstack, 0);
            if (entity != null && target != null && WitcheryIngredientItem.isRestrictedTeleportTarget(entity.dimension, target.dimension)) {
                WitcheryIngredientItem.teleportToLocation(target.posX, target.posY, target.posZ, target.dimension, entity, presetPosition);
                return true;
            }
        }
        return false;
    }

    public boolean hasEffect(ItemStack stack) {
        return stack.getItem() instanceof IngredientItem && (((IngredientItem)stack.getItem()).isEnchanted() || stack.getItem() == WitcheryIngredientItems.SUBDUED_SPIRIT || stack.getItem() == WitcheryIngredientItems.SUBDUED_SPIRIT_VILLAGE);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack itemstack = player.getHeldItem(handIn);
        if (!(itemstack.getItem() instanceof IngredientItem)) {
            return super.onItemRightClick(world, player, handIn);
        }
        if (itemstack.getItem() == WitcheryIngredientItems.WOLFSBANE) {
            RayTraceResult mop;
            if (!world.isRemote && (mop = OtherwhereInfusion.raytraceEntities(world, player, 2.0)) != null && mop.entityHit != null) {
                if (CreatureUtil.isWerewolf(mop.entityHit, true)) {
                    mop.entityHit.playSound(WitcherySounds.ENTITY_WEREWOLF_HOWL, 0.5f, 0.4f / (mop.entityHit.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, 0.5f, 1.5f, EnumParticleTypes.FLAME), mop.entityHit);
                } else {
                    world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
                itemstack.shrink(1);
            }
        } else if (itemstack.getItem() == WitcheryIngredientItems.ICY_NEEDLE) {
            this.useIcyNeedle(world, player, itemstack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.onItemRightClick(world, player, handIn);
    }

    private void useIcyNeedle(World world, EntityPlayer player, ItemStack itemstack) {
        if (!player.capabilities.isCreativeMode) {
            itemstack.shrink(1);
        }
        if (WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world)) {
            WorldProviderSpiritWorld.returnPlayerToOverworld(player);
            itemstack.setCount(0);
        } else if (WitcheryUtils.getExtension(player).getSpiritData().isGhost()) {
            WorldProviderSpiritWorld.returnGhostPlayerToSpiritWorld(player);
            itemstack.setCount(0);
        } else {
            player.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)player), 1.0f);
        }
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.getHeldItem(hand);
        if (itemstack.getItem() == WitcheryIngredientItems.ANNOINTING_PASTE) {
            return this.useAnointingPaste(player, itemstack, world, pos) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        if (itemstack.getItem() == WitcheryIngredientItems.KOBOLDITE_PENTACLE) {
            if (world.getBlockState(pos).getBlock() == WitcheryBlocks.ALTAR && facing == EnumFacing.UP && world.isAirBlock(pos.up())) {
                BlockPlacedItem.placeInWorld(hand, player, world, pos.up());
                return world.isRemote ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
            }
        } else {
            if (itemstack.getItem() == WitcheryIngredientItems.SUBDUED_SPIRIT || itemstack.getItem() == WitcheryIngredientItems.SUBDUED_SPIRIT_VILLAGE) {
                return this.useSubduedSpirit(world, player, itemstack, pos) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            if (itemstack.getItem() == WitcheryIngredientItems.TREEFYD_SEEDS) {
                return this.placeTreefyd(world, player, itemstack, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            if (itemstack.getItem() == WitcheryIngredientItems.BINKY_HEAD) {
                return this.placeBinky(world, itemstack, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return super.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    private boolean placeBinky(World world, ItemStack itemstack, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP) {
            return false;
        }
        Material material = world.getBlockState(pos = pos.up()).getMaterial();
        if (!material.isSolid()) {
            if (!world.isRemote) {
                EntitySkeletonHorse horse = new EntitySkeletonHorse(world);
                horse.experienceValue = 0;
                horse.setHorseTamed(true);
                horse.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3);
                horse.enablePersistence();
                horse.setCustomNameTag(WitcheryResurrected.translate("entity.witchery.binky", new Object[0]));
                horse.setLocationAndAngles(0.5 + (double)pos.getX(), 0.01 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 0.0f, 0.0f);
                NBTTagCompound nbtHorse = horse.getEntityData();
                nbtHorse.setBoolean("WitcheryIsBinky", true);
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.getX(), (double)pos.getY(), 0.5 + (double)pos.getZ(), 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, pos, 16.0);
                world.spawnEntity((Entity)horse);
            }
            itemstack.shrink(1);
        }
        return true;
    }

    private boolean placeTreefyd(World world, EntityPlayer player, ItemStack itemstack, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP) {
            return false;
        }
        pos = pos.up();
        IBlockState state = world.getBlockState(pos);
        Material material = state.getMaterial();
        if (Blocks.TALLGRASS.canBlockStay(world, pos, state) && !material.isSolid()) {
            if (!world.isRemote) {
                world.setBlockState(pos, Blocks.TALLGRASS.getDefaultState().withProperty((IProperty)BlockTallGrass.TYPE, (Comparable)BlockTallGrass.EnumType.GRASS), 3);
                EntityTreefyd entity = new EntityTreefyd(world);
                entity.setLocationAndAngles(0.5 + (double)pos.getX(), pos.getY(), 0.5 + (double)pos.getZ(), 0.0f, 0.0f);
                entity.onInitialSpawn(world.getDifficultyForLocation(entity.getPosition()), null);
                entity.enablePersistence();
                entity.setOwnerId(player.getUniqueID());
                world.spawnEntity((Entity)entity);
                entity.playSound(SoundEvents.ENTITY_SILVERFISH_DEATH, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 1.0f, 2.0f, EnumParticleTypes.SLIME), (Entity)entity);
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 1.0f, 2.0f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)entity);
            }
            itemstack.shrink(1);
        }
        return true;
    }

    private boolean useSubduedSpirit(World world, EntityPlayer player, ItemStack itemstack, BlockPos pos) {
        if (!world.isRemote) {
            EntityCreature creature = Infusion.spawnCreature(world, EntitySpirit.class, pos, null, 0, 0, EnumParticleTypes.SPELL_INSTANT, null);
            if (creature != null) {
                EntitySpirit spirit = (EntitySpirit)creature;
                creature.enablePersistence();
                if (itemstack.getItem() == WitcheryIngredientItems.SUBDUED_SPIRIT_VILLAGE) {
                    spirit.setTarget(1);
                }
                itemstack.shrink(1);
                if (!player.capabilities.isCreativeMode && itemstack.isEmpty() && player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
            }
            return true;
        }
        return false;
    }

    private boolean useAnointingPaste(EntityPlayer player, ItemStack stack, World world, BlockPos pos) {
        IBlockState state;
        Block block;
        if (!world.isRemote && (block = (state = world.getBlockState(pos)).getBlock()) == Blocks.CAULDRON && world.setBlockState(pos, WitcheryBlocks.CAULDRON.getDefaultState())) {
            TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
            if (cauldron != null) {
                cauldron.fill(new FluidStack(FluidRegistry.WATER, Math.round((float)((Integer)state.getValue((IProperty)BlockCauldron.LEVEL)).intValue() * 333.33334f)), true);
            }
            if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            world.playSound(null, (double)x, (double)y, (double)z, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)x, (double)y, (double)z, 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, pos);
            world.playSound(null, (double)x, (double)y, (double)z, SoundEvents.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)x, (double)y, (double)z, 1.0f, 1.0f, EnumParticleTypes.EXPLOSION_LARGE), world, pos);
        }
        return true;
    }

    private static class WitcheryTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        public WitcheryTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public WitcheryTeleporter() {
            this.targetPos = null;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            if (this.targetPos != null) {
                entity.moveToBlockPosAndAngles(this.targetPos, yaw, entity.rotationPitch);
            }
        }
    }
}

