/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.ingredients;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;

public class IngredientItem
extends WitcheryIngredientItem {
    public final EnumRarity rarity;
    protected boolean enchanted;
    protected boolean potion;

    public IngredientItem() {
        this(EnumRarity.COMMON, true);
    }

    public IngredientItem(EnumRarity rarity) {
        this(rarity, true);
    }

    public IngredientItem(EnumRarity rarity, boolean showInCreativeTab) {
        this.rarity = rarity;
        this.enchanted = false;
        this.potion = false;
        if (showInCreativeTab) {
            this.setCreativeTab(WitcheryGeneralItems.TAB);
        }
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return this.rarity;
    }

    public static int getItemSlotFromInventory(InventoryPlayer inventory, Item item) {
        for (int k = 0; k < inventory.mainInventory.size(); ++k) {
            if (((ItemStack)inventory.mainInventory.get(k)).getItem() != item) continue;
            return k;
        }
        return -1;
    }

    public boolean isEnchanted() {
        return this.enchanted || this.potion;
    }

    public IngredientItem setEnchanted(boolean enchanted) {
        this.enchanted = enchanted;
        return this;
    }

    public IngredientItem setPotion(boolean potion) {
        this.potion = potion;
        return this;
    }
}

