/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.contracts;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityLordOfTorment;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.items.WitcheryContractItems;
import net.msrandom.witchery.item.contracts.ItemContract;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J@\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0016\u00a8\u0006%"}, d2={"Lnet/msrandom/witchery/item/contracts/ItemTormentContract;", "Lnet/msrandom/witchery/item/contracts/ItemContract;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "circleNear", "", "world", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "getMaxItemUseDuration", "", "isPost", "x", "y", "z", "bottomSolid", "midSolid", "topSolid", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "hand", "Lnet/minecraft/util/EnumHand;", "onUsingTick", "Lnet/minecraft/entity/EntityLivingBase;", "count", "WitcheryResurrected"})
public final class ItemTormentContract
extends ItemContract {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.addInformation(stack, worldIn, tooltip, flagIn);
        String string = I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"$translationKey.tip\")");
        tooltip.addAll(StringsKt.split$default((CharSequence)string, (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null));
    }

    public int getMaxItemUseDuration(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 1200;
    }

    @NotNull
    public EnumAction getItemUseAction(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumAction.BOW;
    }

    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player, int count) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.onUsingTick(stack, player, count);
        World world = player.world;
        if (world.isRemote) return;
        if (!(player instanceof EntityPlayer)) return;
        int elapsedTicks = stack.getMaxItemUseDuration() - count;
        if (elapsedTicks % 40 != 0) return;
        if (elapsedTicks <= 40) {
            if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
            if (elapsedTicks <= 0) {
                World world2 = world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
                if (!this.circleNear(world2, (EntityPlayer)player)) {
                    EntityPlayer entityPlayer = (EntityPlayer)player;
                    SoundEvent soundEvent = SoundEvents.BLOCK_NOTE_SNARE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.BLOCK_NOTE_SNARE");
                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    player.sendMessage(new TextComponentTranslation(WitcheryContractItems.TORMENT_CONTRACT.getTranslationKey() + ".not_centered", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    player.resetActiveHand();
                    return;
                }
            }
            EntityPlayer entityPlayer = (EntityPlayer)player;
            SoundEvent soundEvent = SoundEvents.ENTITY_BLAZE_DEATH;
            Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.ENTITY_BLAZE_DEATH");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            return;
        }
        int n = elapsedTicks;
        if (80 <= n && 120 >= n) {
            if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
            world.playSound(null, ((EntityPlayer)player).getPosition(), SoundEvents.ENTITY_BLAZE_DEATH, ((EntityPlayer)player).getSoundCategory(), 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
            World world3 = world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"world");
            WitcheryUtils.addNewParticles(world3, EnumParticleTypes.SPELL_MOB, player.posX, player.posY, player.posZ, 0.0, 20, 1.0, 2.0);
            return;
        }
        n = elapsedTicks;
        if (160 <= n && 240 >= n) {
            if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
            world.playSound(null, ((EntityPlayer)player).getPosition(), SoundEvents.ENTITY_BLAZE_DEATH, ((EntityPlayer)player).getSoundCategory(), 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
            World world4 = world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world4, (String)"world");
            WitcheryUtils.addNewParticles(world4, EnumParticleTypes.SPELL_MOB, player.posX, player.posY, player.posZ, 0.0, 20, 1.0, 2.0);
            WitcheryUtils.addNewParticles(world, EnumParticleTypes.FLAME, player.posX, player.posY, player.posZ, 0.0, 20, 1.0, 2.0);
            return;
        }
        if (elapsedTicks < 280) return;
        if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
        World world5 = world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world5, (String)"world");
        if (!this.circleNear(world5, (EntityPlayer)player)) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            SoundEvent soundEvent = SoundEvents.BLOCK_NOTE_SNARE;
            Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.BLOCK_NOTE_SNARE");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            player.resetActiveHand();
            return;
        }
        WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_MOB, player.posX, player.posY, player.posZ, 0.0, 20, 1.0, 2.0);
        WitcheryUtils.addNewParticles(world, EnumParticleTypes.FLAME, player.posX, player.posY, player.posZ, 0.0, 40, 1.0, 2.0);
        player.resetActiveHand();
        EntityLiving living = (EntityLiving)Infusion.spawnCreature(world, EntityLordOfTorment.class, ((EntityPlayer)player).getPosition(), null, 2, 4, EnumParticleTypes.FLAME, SoundEvents.ENTITY_ENDERDRAGON_GROWL);
        if (living == null) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            SoundEvent soundEvent = SoundEvents.BLOCK_NOTE_SNARE;
            Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.BLOCK_NOTE_SNARE");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            return;
        }
        if (!((EntityPlayer)player).capabilities.isCreativeMode) {
            stack.shrink(1);
        }
        living.enablePersistence();
        world.newExplosion((Entity)living, living.posX, living.posY + (double)living.getEyeHeight(), living.posZ, 7.0f, false, world.getGameRules().getBoolean("mobGriefing"));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean circleNear(World world, EntityPlayer player) {
        int midX = MathHelper.floor((double)player.posX);
        int midY = MathHelper.floor((double)player.posY);
        int midZ = MathHelper.floor((double)player.posZ);
        int[][] pattern = new int[][]{{0, 0, 0, 0, 4, 3, 4, 0, 0, 0, 0}, {0, 0, 4, 3, 1, 1, 1, 3, 4, 0, 0}, {0, 4, 1, 1, 1, 1, 1, 1, 1, 4, 0}, {0, 3, 1, 1, 1, 1, 1, 1, 1, 3, 0}, {4, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4}, {3, 1, 1, 1, 2, 1, 2, 1, 1, 1, 3}, {4, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4}, {0, 3, 1, 1, 1, 1, 1, 1, 1, 3, 0}, {0, 4, 1, 1, 1, 1, 1, 1, 1, 4, 0}, {0, 0, 4, 3, 1, 1, 1, 3, 4, 0, 0}, {0, 0, 0, 0, 4, 3, 4, 0, 0, 0, 0}};
        int offsetZ = (((Object[])pattern).length - 1) / 2;
        int n = 0;
        int n2 = ((Object[])pattern).length - 1;
        while (n < n2) {
            void z;
            int worldZ = midZ - offsetZ + z;
            int offsetX = (pattern[z].length - 1) / 2;
            int n3 = 0;
            int n4 = pattern[z].length;
            while (n3 < n4) {
                void x;
                int worldX = midX - offsetX + x;
                int value = pattern[((Object[])pattern).length - 1 - z][x];
                if (value != 0 && !this.isPost(world, worldX, midY, worldZ, value == 2 || value == 4, value == 4, value == 3 || value == 4)) {
                    return false;
                }
                ++x;
            }
            ++z;
        }
        return true;
    }

    private final boolean isPost(World world, int x, int y, int z, boolean bottomSolid, boolean midSolid, boolean topSolid) {
        IBlockState blockBelow = BlockUtil.getBlock(world, x, y - 1, z);
        IBlockState blockBottom = BlockUtil.getBlock(world, x, y, z);
        IBlockState blockMid = BlockUtil.getBlock(world, x, y + 1, z);
        IBlockState blockTop = BlockUtil.getBlock(world, x, y + 2, z);
        IBlockState blockAbove = BlockUtil.getBlock(world, x, y + 3, z);
        IBlockState iBlockState = blockBelow;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockBelow");
        Material material = iBlockState.getMaterial();
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"blockBelow.material");
        if (!material.isSolid()) {
            return false;
        }
        if (bottomSolid) {
            IBlockState iBlockState2 = blockBottom;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"blockBottom");
            Material material2 = iBlockState2.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material2, (String)"blockBottom.material");
            if (!material2.isSolid()) {
                return false;
            }
        } else {
            IBlockState iBlockState3 = blockBottom;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState3, (String)"blockBottom");
            Material material3 = iBlockState3.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material3, (String)"blockBottom.material");
            if (material3.isSolid()) {
                return false;
            }
        }
        if (midSolid) {
            IBlockState iBlockState4 = blockMid;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState4, (String)"blockMid");
            Material material4 = iBlockState4.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material4, (String)"blockMid.material");
            if (!material4.isSolid()) {
                return false;
            }
        } else {
            IBlockState iBlockState5 = blockMid;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState5, (String)"blockMid");
            Material material5 = iBlockState5.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material5, (String)"blockMid.material");
            if (material5.isSolid()) {
                return false;
            }
        }
        if (topSolid) {
            IBlockState iBlockState6 = blockTop;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState6, (String)"blockTop");
            Material material6 = iBlockState6.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material6, (String)"blockTop.material");
            if (!material6.isSolid()) {
                return false;
            }
        } else {
            IBlockState iBlockState7 = blockTop;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState7, (String)"blockTop");
            Material material7 = iBlockState7.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material7, (String)"blockTop.material");
            if (material7.isSolid()) {
                return false;
            }
        }
        IBlockState iBlockState8 = blockAbove;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState8, (String)"blockAbove");
        Material material8 = iBlockState8.getMaterial();
        Intrinsics.checkExpressionValueIsNotNull((Object)material8, (String)"blockAbove.material");
        return !material8.isSolid();
    }
}

