/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.contracts;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.msrandom.witchery.item.contracts.ItemActivatableContract;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/item/contracts/ItemBlazeContract;", "Lnet/msrandom/witchery/item/contracts/ItemActivatableContract;", "()V", "activate", "", "targetEntity", "Lnet/minecraft/entity/EntityLivingBase;", "WitcheryResurrected"})
public final class ItemBlazeContract
extends ItemActivatableContract {
    @Override
    public boolean activate(@NotNull EntityLivingBase targetEntity) {
        Intrinsics.checkParameterIsNotNull((Object)targetEntity, (String)"targetEntity");
        if (!targetEntity.world.isRemote) {
            Random random = targetEntity.getRNG();
            EntityBlaze blaze = new EntityBlaze(targetEntity.world);
            double x = targetEntity.posX + (double)random.nextInt(4) - (double)2;
            double y = targetEntity.posY + 1.0;
            double z = targetEntity.posZ + (double)random.nextInt(4) - (double)2;
            blaze.setLocationAndAngles(x, y, z, 0.0f, 0.0f);
            blaze.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            IAttributeInstance iAttributeInstance = blaze.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
            Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"blaze.getEntityAttribute\u2026terAttributes.MAX_HEALTH)");
            iAttributeInstance.setBaseValue(50.0);
            IAttributeInstance iAttributeInstance2 = blaze.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
            Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"blaze.getEntityAttribute\u2026Attributes.ATTACK_DAMAGE)");
            iAttributeInstance2.setBaseValue(7.0);
            targetEntity.world.spawnEntity((Entity)blaze);
            World world = targetEntity.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"targetEntity.world");
            WitcheryUtils.addNewParticles$default(world, EnumParticleTypes.FLAME, x, y, z, 0.0, 20, 0.0, 0.0, 192, null);
            return true;
        }
        return false;
    }
}

