/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.EffectSpiral;
import net.msrandom.witchery.util.ISpiralBlockAction;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSubstitutionBrew
extends ItemKettleBrew {
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, final @NotNull RayTraceResult hit, boolean enhanced) {
        if (hit.typeOfHit != RayTraceResult.Type.BLOCK) {
            return this.dropItem(world, hit);
        }
        final double r = enhanced ? 6.0 : 4.0;
        List entities = world.getEntitiesWithinAABB(EntityItem.class, projectile.getEntityBoundingBox().grow(r));
        if (!entities.isEmpty()) {
            final ArrayList<EntityItem> items = new ArrayList<EntityItem>();
            for (EntityItem item : entities) {
                ItemStack stack;
                double distanceSq = item.getDistanceSq((Entity)projectile);
                if (!(distanceSq <= r * r) || !((stack = item.getItem()).getItem() instanceof ItemBlock)) continue;
                items.add(item);
            }
            final IBlockState state = world.getBlockState(hit.getBlockPos());
            final Block refBlock = state.getBlock();
            if (items.size() > 0 && WitcheryUtils.canBreak(state)) {
                new EffectSpiral(new ISpiralBlockAction(){
                    int stackIndex = 0;
                    int subCount = 0;

                    @Override
                    public boolean onSpiralBlockAction(World world, int posX, int posY, int posZ) {
                        if (hit.getBlockPos().distanceSq((double)posX, (double)posY, (double)posZ) < r * r) {
                            boolean found = false;
                            if (BlockUtil.getBlock(world, posX, posY, posZ).getBlock() == refBlock && BlockUtil.isReplaceableBlock(world, posX, posY + 1, posZ)) {
                                found = true;
                            } else if (BlockUtil.getBlock(world, posX, posY + 1, posZ).getBlock() == refBlock && BlockUtil.isReplaceableBlock(world, posX, posY + 2, posZ)) {
                                ++posY;
                                found = true;
                            } else if (BlockUtil.getBlock(world, posX, posY - 1, posZ).getBlock() == refBlock && BlockUtil.isReplaceableBlock(world, posX, posY, posZ)) {
                                --posY;
                                found = true;
                            } else if (BlockUtil.getBlock(world, posX, posY + 2, posZ).getBlock() == refBlock && BlockUtil.isReplaceableBlock(world, posX, posY + 3, posZ)) {
                                posY += 2;
                                found = true;
                            } else if (BlockUtil.getBlock(world, posX, posY - 2, posZ).getBlock() == refBlock && BlockUtil.isReplaceableBlock(world, posX, posY - 1, posZ)) {
                                posY -= 2;
                                found = true;
                            }
                            if (found) {
                                ++this.subCount;
                                ItemStack stack = ((EntityItem)items.get(this.stackIndex)).getItem();
                                BlockUtil.setBlock(world, posX, posY, posZ, (ItemBlock)stack.getItem(), stack.getItemDamage(), 3);
                                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)posX, (double)posY, (double)posZ, 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, posX, posY, posZ);
                                stack.shrink(1);
                                if (stack.isEmpty()) {
                                    ((EntityItem)items.get(this.stackIndex)).setDead();
                                    ++this.stackIndex;
                                }
                            }
                        }
                        return this.stackIndex < items.size();
                    }

                    @Override
                    public void onSpiralActionStop(World world, int posX, int posY, int posZ) {
                        while (this.subCount > 0) {
                            int quantity = Math.min(this.subCount, 64);
                            this.subCount -= quantity;
                            world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)posX, 1.5 + (double)posY, 0.5 + (double)posZ, new ItemStack(refBlock, quantity, refBlock.damageDropped(state))));
                        }
                    }
                }).apply(world, hit.getBlockPos().getX(), hit.getBlockPos().getY(), hit.getBlockPos().getZ(), (int)(r * 2.0), (int)(r * 2.0));
                return true;
            }
        }
        return true;
    }
}

