/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSolidifyBrew
extends ItemKettleBrew {
    protected final Block replacementBlock;

    public ItemSolidifyBrew(Block block) {
        this.replacementBlock = block;
    }

    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        if (hit.typeOfHit == RayTraceResult.Type.ENTITY) {
            return this.dropItem(world, hit);
        }
        IBlockState blockHit = BlockUtil.getBlock(world, hit);
        BlockPos pos = hit.getBlockPos();
        if (blockHit.getBlock() != WitcheryBlocks.HOLLOW_TEARS && (blockHit = BlockUtil.getBlock(world, (pos = pos.offset(hit.sideHit)).getX(), pos.getY(), pos.getZ())).getBlock() != WitcheryBlocks.HOLLOW_TEARS) {
            return this.dropItem(world, hit);
        }
        SpreadEffect.spread(world, pos.getX(), pos.getY(), pos.getZ(), 64, new SpreadEffect(new Block[]{WitcheryBlocks.HOLLOW_TEARS}){

            @Override
            public boolean doEffect(World world, int posX, int posY, int posZ) {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)posX, 1.5 + (double)posY, 0.5 + (double)posZ, 2.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), world, 0.5 + (double)posX, 1.5 + (double)posY, 0.5 + (double)posZ);
                if (ItemSolidifyBrew.this.replacementBlock == null) {
                    BlockPos pos = new BlockPos(posX, posY, posZ);
                    world.setBlockToAir(pos);
                    IBlockState blockBelow = BlockUtil.getBlock(world, posX, posY - 1, posZ);
                    if (WitcheryUtils.canBreak(blockBelow)) {
                        world.setBlockToAir(pos.down());
                    }
                } else {
                    BlockUtil.setBlock(world, posX, posY, posZ, ItemSolidifyBrew.this.replacementBlock.getDefaultState(), 3);
                }
                return true;
            }
        });
        return true;
    }

    public static abstract class SpreadEffect {
        protected final Block[] blocks;

        public SpreadEffect(Block ... blocksToSpreadOver) {
            this.blocks = blocksToSpreadOver;
        }

        public static void spread(World world, int x0, int y0, int z0, int range, SpreadEffect effect) {
            SpreadEffect.spread(world, x0, y0, z0, x0, y0, z0, range, effect);
        }

        private static void spread(World world, int x, int y, int z, int x0, int y0, int z0, int range, SpreadEffect effect) {
            if (Math.abs(x0 - x) >= range || Math.abs(y0 - y) >= range || Math.abs(z0 - z) >= range) {
                return;
            }
            if (SpreadEffect.checkEffect(world, x + 1, y, z, effect)) {
                SpreadEffect.spread(world, x + 1, y, z, x0, y0, z0, range, effect);
            }
            if (SpreadEffect.checkEffect(world, x - 1, y, z, effect)) {
                SpreadEffect.spread(world, x - 1, y, z, x0, y0, z0, range, effect);
            }
            if (SpreadEffect.checkEffect(world, x, y, z + 1, effect)) {
                SpreadEffect.spread(world, x, y, z + 1, x0, y0, z0, range, effect);
            }
            if (SpreadEffect.checkEffect(world, x, y, z - 1, effect)) {
                SpreadEffect.spread(world, x, y, z - 1, x0, y0, z0, range, effect);
            }
            if (SpreadEffect.checkEffect(world, x, y + 1, z, effect)) {
                SpreadEffect.spread(world, x, y + 1, z, x0, y0, z0, range, effect);
            }
            if (SpreadEffect.checkEffect(world, x, y - 1, z, effect)) {
                SpreadEffect.spread(world, x, y - 1, z, x0, y0, z0, range, effect);
            }
        }

        private static boolean checkEffect(World world, int x, int y, int z, SpreadEffect effect) {
            boolean continueSpread = false;
            IBlockState foundBlock = BlockUtil.getBlock(world, x, y, z);
            for (Block block : effect.blocks) {
                if (foundBlock.getBlock() != block) continue;
                continueSpread = effect.doEffect(world, x, y, z);
                break;
            }
            return continueSpread;
        }

        public abstract boolean doEffect(World var1, int var2, int var3, int var4);
    }
}

