/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/item/brews/ItemRevealingBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "impact", "", "world", "Lnet/minecraft/world/World;", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "WitcheryResurrected"})
public final class ItemRevealingBrew
extends ItemKettleBrew {
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectile), (String)"projectile");
        Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
        double r = enhanced ? 8.0 : 5.0;
        for (EntityLivingBase entityLiving : world.getEntitiesWithinAABB(EntityLivingBase.class, projectile.getEntityBoundingBox().grow(r))) {
            PlayerExtendedData playerEx;
            double distanceSq = entityLiving.getDistanceSq((Entity)projectile);
            if (!(distanceSq <= r * r)) continue;
            if (entityLiving.isPotionActive(MobEffects.INVISIBILITY)) {
                entityLiving.removePotionEffect(MobEffects.INVISIBILITY);
            }
            EntityLivingBase entityLivingBase = entityLiving;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"entityLiving");
            if (entityLivingBase.isInvisible()) {
                entityLiving.setInvisible(false);
            }
            if (entityLiving instanceof EntityPlayer && Intrinsics.areEqual((Object)(playerEx = WitcheryUtils.getExtension((EntityPlayer)entityLiving)).getCurrentForm(), (Object)WitcheryAlternateForms.PLAYER)) {
                entityLiving.world.playSound(null, ((EntityPlayer)entityLiving).getPosition(), WitcherySounds.ENTITY_VAMPIRE_POOF, SoundCategory.PLAYERS, 0.5f, 0.4f / (((EntityPlayer)entityLiving).getRNG().nextFloat() * 0.4f + 0.8f));
                World world2 = entityLiving.world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"entityLiving.world");
                WitcheryUtils.addNewParticles(world2, EnumParticleTypes.SMOKE_NORMAL, entityLiving.posX, entityLiving.posY, entityLiving.posZ, 0.0, 20, 0.5, 2.0);
                playerEx.setCurrentForm(null);
            }
            if (!(entityLiving instanceof EntitySummonedUndead) || !((EntitySummonedUndead)entityLiving).isObscured()) continue;
            ((EntitySummonedUndead)entityLiving).setObscured(false);
        }
        return true;
    }

    public ItemRevealingBrew() {
        super(false, 1, null);
    }
}

