/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/item/brews/ItemLoveBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "giveBirth", "", "world", "Lnet/minecraft/world/World;", "villager", "Lnet/minecraft/entity/passive/EntityVillager;", "mate", "impact", "", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "WitcheryResurrected"})
public final class ItemLoveBrew
extends ItemKettleBrew {
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        EntityVillager first;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectile), (String)"projectile");
        Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
        double r = enhanced ? 5.0 : 4.0;
        EntityLivingBase entityLivingBase = caster;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            entityLivingBase = null;
        }
        EntityPlayer thrower = (EntityPlayer)entityLivingBase;
        boolean bl = false;
        List villagers = new ArrayList();
        boolean bl2 = false;
        List zombies = new ArrayList();
        for (EntityLiving entity : world.getEntitiesWithinAABB(EntityLiving.class, projectile.getEntityBoundingBox().grow(r, 2.0, r))) {
            double distance = entity.getDistanceSq(projectile.posX, projectile.posY, projectile.posZ);
            if (!(distance < r * r)) continue;
            if (entity instanceof EntityAnimal) {
                if (((EntityAnimal)entity).getGrowingAge() < 0) continue;
                ((EntityAnimal)entity).setGrowingAge(0);
                ((EntityAnimal)entity).setInLove(null);
                continue;
            }
            if (entity instanceof EntityVillager) {
                if (((EntityVillager)entity).getGrowingAge() < 0) continue;
                villagers.add(entity);
                continue;
            }
            if (!(entity instanceof EntityZombie) || ((EntityZombie)entity).isChild() || thrower == null || !PotionEnslaved.isMobEnslavedBy(entity, thrower)) continue;
            zombies.add(entity);
        }
        int limit = 10;
        while (villagers.size() > 1 && limit-- > 0) {
            first = (EntityVillager)villagers.get(0);
            EntityVillager second = (EntityVillager)villagers.get(1);
            first.setPosition(second.posX, second.posY, second.posZ);
            WitcheryUtils.addNewParticles(world, EnumParticleTypes.HEART, second.posX, second.posY, second.posZ, 0.0, 20, 1.0, 2.0);
            this.giveBirth(world, first, second);
            villagers.remove(0);
            villagers.remove(0);
        }
        limit = 10;
        while (zombies.size() > 1 && limit-- > 0) {
            EntityZombieVillager zombieVillager;
            first = (EntityZombie)zombies.get(0);
            EntityZombie second = (EntityZombie)zombies.get(1);
            first.setPosition(second.posX, second.posY, second.posZ);
            WitcheryUtils.addNewParticles(world, EnumParticleTypes.HEART, second.posX, second.posY, second.posZ, 0.0, 20, 1.0, 2.0);
            if (!(first instanceof EntityZombieVillager)) {
                zombieVillager = new EntityZombieVillager(world);
                zombieVillager.setLocationAndAngles(first.posX, first.posY, first.posZ, 0.0f, 0.0f);
                zombieVillager.onInitialSpawn(world.getDifficultyForLocation(zombieVillager.getPosition()), null);
                world.removeEntity((Entity)first);
                world.spawnEntity((Entity)zombieVillager);
            }
            if (!(second instanceof EntityZombieVillager)) {
                zombieVillager = new EntityZombieVillager(world);
                zombieVillager.setLocationAndAngles(second.posX, second.posY, second.posZ, 0.0f, 0.0f);
                zombieVillager.onInitialSpawn(world.getDifficultyForLocation(zombieVillager.getPosition()), null);
                world.removeEntity((Entity)second);
                world.spawnEntity((Entity)zombieVillager);
            }
            EntityZombie baby = new EntityZombie(world);
            baby.setLocationAndAngles(second.posX, second.posY, second.posZ, 0.0f, 0.0f);
            baby.setChild(true);
            world.spawnEntity((Entity)baby);
            zombies.remove(0);
            zombies.remove(0);
        }
        return true;
    }

    private final void giveBirth(World world, EntityVillager villager, EntityVillager mate) {
        EntityVillager child = villager.createChild((EntityAgeable)mate);
        mate.setGrowingAge(6000);
        villager.setGrowingAge(6000);
        if (child != null) {
            child.setGrowingAge(-24000);
            child.setLocationAndAngles(villager.posX, villager.posY, villager.posZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)child);
            world.setEntityState((Entity)child, (byte)12);
        }
    }

    public ItemLoveBrew() {
        super(false, 1, null);
    }
}

