/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFluidBrew
extends ItemKettleBrew {
    protected final Fluid fluid;

    public ItemFluidBrew(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        switch (hit.typeOfHit) {
            case BLOCK: {
                this.depositLiquid(world, hit.getBlockPos(), hit.sideHit);
                break;
            }
            case ENTITY: {
                this.depositLiquid(world, hit.entityHit.getPosition(), null);
            }
        }
        return true;
    }

    public void depositLiquid(World world, BlockPos pos, EnumFacing side) {
        BlockPos p;
        BlockPos blockPos = p = side == null ? pos : pos.offset(side);
        if (side == EnumFacing.UP && !world.getBlockState(pos).getMaterial().isSolid()) {
            p = p.down();
        }
        if (!world.getBlockState(p).getMaterial().isSolid()) {
            world.setBlockState(p, this.fluid.getBlock().getDefaultState(), 3);
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)p.getX(), 0.5 + (double)p.getY(), 0.5 + (double)p.getZ(), 1.0f, 1.0f, EnumParticleTypes.EXPLOSION_NORMAL), world, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, 16.0);
        }
    }
}

